/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.templatespringext.processor;

import org.tinygroup.logger.LogLevel;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.templatespringext.AbstractFileProcessor;
import org.tinygroup.vfs.FileObject;

public class TinyMacroProcessor
extends AbstractFileProcessor {
    private static final String MACRO_FILE_EXT = ".component";
    private TemplateEngine engine;

    public TemplateEngine getEngine() {
        return this.engine;
    }

    public void setEngine(TemplateEngine engine) {
        this.engine = engine;
    }

    @Override
    public void process() {
        if (this.fileList.size() > 0) {
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u52a0\u8f7dMacro\u6587\u4ef6...");
            for (FileObject file : this.fileList) {
                this.getFileResourceManager().addResources(this.engine, file, ".page", ".layout", MACRO_FILE_EXT);
            }
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dMacro\u6587\u4ef6\u7ed3\u675f...");
        }
    }

    @Override
    public boolean isMatch(String fileName) {
        return fileName.endsWith(MACRO_FILE_EXT);
    }

    public String getPath(FileObject fileObject) {
        String absolutePath = fileObject.getAbsolutePath();
        if (absolutePath.contains("resources")) {
            return this.modifyPath(fileObject, "resources").substring(1);
        }
        if (absolutePath.contains("classes")) {
            return this.modifyPath(fileObject, "classes").substring(1);
        }
        return fileObject.getPath();
    }

    public String modifyPath(FileObject file, String parent) {
        if (!parent.equals(file.getFileName())) {
            return this.modifyPath(file.getParent(), parent) + "/" + file.getFileName();
        }
        return "";
    }
}

