/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.templatespringext.springext;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.TemplateFunction;
import org.tinygroup.templatespringext.FileScanner;
import org.tinygroup.templatespringext.springext.TinyTemplateLayoutView;

public class TinyTemplateLayoutViewResolver
extends AbstractTemplateViewResolver {
    private static final String VIEW_EXT_FILENAME = "page";
    private static final String PAGELET_EXT_FILE_NAME = "pagelet";
    private static final String MacroExt = "component";
    private String viewExtFileName = "page";
    private String noLayoutExtFileName = "pagelet";
    private TemplateEngine templateEngine;
    private FileScanner fileScanner;
    private List<String> classPathList = new ArrayList<String>();
    private boolean checkModify = true;

    public TinyTemplateLayoutViewResolver() {
        this.setViewClass(this.requiredViewClass());
    }

    public boolean isCheckModify() {
        return this.checkModify;
    }

    public void setCheckModify(boolean checkModify) {
        this.checkModify = checkModify;
    }

    public FileScanner getFileScanner() {
        return this.fileScanner;
    }

    public void setFileScanner(FileScanner fileScanner) {
        this.fileScanner = fileScanner;
    }

    public List<String> getClassPathList() {
        return this.classPathList;
    }

    public void setClassPathList(List<String> classPathList) {
        this.classPathList = classPathList;
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    protected void initApplicationContext() {
        super.initApplicationContext();
        this.initEngine();
        this.initFunctions();
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        TinyTemplateLayoutView layoutView = (TinyTemplateLayoutView)super.buildView(viewName);
        Assert.assertNotNull((Object)this.templateEngine, (String)"templateEngine must not be null", (Object[])new Object[0]);
        layoutView.setTemplateEngine(this.templateEngine);
        layoutView.setUrl(this.getPrefix() + this.generateUrl(viewName));
        layoutView.setNoLayoutExtFileName(this.noLayoutExtFileName);
        layoutView.setViewExtFileName(this.viewExtFileName);
        return layoutView;
    }

    private void initEngine() {
        this.templateEngine.setCheckModified(this.checkModify);
        this.fileScanner.setEngine(this.templateEngine);
        this.fileScanner.init();
        this.fileScanner.scanFile();
        this.fileScanner.fileProcess();
    }

    private String generateUrl(String viewName) {
        StringBuffer url = new StringBuffer();
        if (viewName.startsWith("/") && !this.getPrefix().endsWith("/")) {
            url.append(viewName);
        } else if (!viewName.startsWith("/") && this.getPrefix().endsWith("/")) {
            url.append(viewName);
        } else if (viewName.startsWith("/") && this.getPrefix().endsWith("/")) {
            viewName = viewName.substring(viewName.lastIndexOf("/") + 1);
            url.append(viewName);
        } else {
            url.append("/").append(viewName);
        }
        int sepIndex = viewName.lastIndexOf(".");
        if (sepIndex == -1) {
            url.append(".").append(this.viewExtFileName);
        }
        return url.toString();
    }

    protected Class requiredViewClass() {
        return TinyTemplateLayoutView.class;
    }

    private void initFunctions() {
        Map functions = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), TemplateFunction.class, (boolean)true, (boolean)false);
        for (TemplateFunction f : functions.values()) {
            this.templateEngine.addTemplateFunction(f);
        }
    }
}

