/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.distributed;

import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.sequence.impl.MultipleSequenceDao;
import org.tinygroup.sequence.impl.MultipleSequenceFactory;
import org.tinygroup.tinydb.dialect.impl.MySQLDialect;
import org.tinygroup.tinydb.exception.TinyDbException;

public class MultiDistributedMySQLDialect
extends MySQLDialect
implements InitializingBean {
    private List<DataSource> dataSources;
    private String sequenceName;
    private MultipleSequenceFactory sequenceFactory;

    public void setDataSources(List<DataSource> dataSources) {
        this.dataSources = dataSources;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public int getNextKey() {
        try {
            return new Long(this.sequenceFactory.getNextValue(this.sequenceName)).intValue();
        }
        catch (Exception e) {
            throw new TinyDbException("\u83b7\u53d6\u5206\u5e03\u5f0f\u4e3b\u952e\u503c\u51fa\u9519", (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.assertTrue((boolean)(this.dataSources == null ? false : this.dataSources.size() > 1), (String)"\u4e3a\u4fdd\u8bc1\u9ad8\u53ef\u7528\uff0c\u6570\u636e\u6e90\u7684\u4e2a\u6570\u5efa\u8bae\u8bbe\u7f6e\u591a\u4e8e\u4e24\u4e2a", (Object[])new Object[0]);
        Assert.assertTrue((!StringUtil.isBlank((String)this.sequenceName) ? 1 : 0) != 0, (String)"sequenceName must not null or empty", (Object[])new Object[0]);
        this.sequenceFactory = new MultipleSequenceFactory();
        MultipleSequenceDao multipleSequenceDao = new MultipleSequenceDao();
        multipleSequenceDao.setDataSourceList(this.dataSources);
        this.sequenceFactory.setMultipleSequenceDao(multipleSequenceDao);
        this.sequenceFactory.init();
    }
}

