/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.distributed;

import org.springframework.beans.factory.InitializingBean;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.sequence.SequenceDao;
import org.tinygroup.sequence.impl.DefaultSequence;
import org.tinygroup.sequence.impl.DefaultSequenceDao;
import org.tinygroup.tinydb.dialect.impl.MySQLDialect;

public class SingleDistributedMySQLDialect
extends MySQLDialect
implements InitializingBean {
    private String sequenceName;
    private DefaultSequence defaultSequence;
    private int step;

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public int getNextKey() {
        return new Long(this.defaultSequence.nextValue()).intValue();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.assertNotNull((Object)this.getDataSource(), (String)"datasource must not null", (Object[])new Object[0]);
        Assert.assertTrue((!StringUtil.isBlank((String)this.sequenceName) ? 1 : 0) != 0, (String)"sequenceName must not null or empty", (Object[])new Object[0]);
        DefaultSequenceDao sequenceDao = new DefaultSequenceDao();
        sequenceDao.setDataSource(this.getDataSource());
        if (this.step > 0) {
            sequenceDao.setStep(this.step);
        }
        this.defaultSequence = new DefaultSequence();
        this.defaultSequence.setSequenceDao((SequenceDao)sequenceDao);
        this.defaultSequence.setName(this.sequenceName);
    }
}

