/**
 * Copyright (c) 2012-2016, www.tinygroup.org (luo_guo@icloud.com).
 * <p>
 * Licensed under the GPL, Version 3.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.gnu.org/licenses/gpl.html
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.tinygroup.weblayer.mvc.handlermapping;

import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.weblayer.mvc.HandlerMapping;
import org.tinygroup.weblayer.mvc.MappingModelManager;

/**
 * 功能说明: 抽象的handlermapping
 * <p>
 * 开发人员: renhui <br>
 * 开发时间: 2013-4-22 <br>
 * <br>
 */
public abstract class AbstractHandlerMapping implements HandlerMapping {

    private MappingModelManager manager;

    public MappingModelManager getManager() {
        return manager;
    }

    public void setManager(MappingModelManager manager) {
        this.manager = manager;
    }

    public void init() {
        if (manager == null) {
            manager = BeanContainerFactory.getBeanContainer(
                    this.getClass().getClassLoader()).getBean(
                    "mappingModelManager");
        }
    }

}
