/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.uiengine.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.uiengine.config.UIComponents;
import org.tinygroup.uiengine.manager.UIComponentManager;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class UIComponentFileProcessor
extends AbstractFileProcessor {
    UIComponentManager manager;

    public UIComponentManager getManager() {
        return this.manager;
    }

    public void setManager(UIComponentManager manager) {
        this.manager = manager;
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"uicomponents");
        for (FileObject fileObject : this.deleteList) {
            logger.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664uicomponent\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            UIComponents uiComponents = (UIComponents)this.caches.get(fileObject.getAbsolutePath());
            if (uiComponents != null) {
                this.manager.removeUIComponents(uiComponents);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            logger.logMessage(LogLevel.INFO, "\u79fb\u9664uicomponent\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            logger.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7duicomponent\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            UIComponents oldUiComponents = (UIComponents)this.caches.get(fileObject.getAbsolutePath());
            if (oldUiComponents != null) {
                this.manager.removeUIComponents(oldUiComponents);
            }
            UIComponents uiComponents = (UIComponents)stream.fromXML(fileObject.getInputStream());
            this.manager.addUIComponents(uiComponents);
            this.caches.put(fileObject.getAbsolutePath(), uiComponents);
            logger.logMessage(LogLevel.INFO, "\u52a0\u8f7duicomponent\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(".ui.xml");
    }
}

