/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer;

import javax.servlet.ServletException;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.TinyFilter;
import org.tinygroup.weblayer.TinyFilterConfig;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.webcontext.DefaultWebContext;

public abstract class AbstractTinyFilter
implements TinyFilter {
    protected static Logger logger = LoggerFactory.getLogger(AbstractTinyFilter.class);
    protected String filterName;
    protected TinyFilterConfig tinyFilterConfig;

    @Override
    public void initTinyFilter(TinyFilterConfig config) throws ServletException {
        this.tinyFilterConfig = config;
        this.customInit();
    }

    protected abstract void customInit();

    @Override
    public String getFilterName() {
        return this.filterName;
    }

    @Override
    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    @Override
    public void destroyTinyFilter() {
    }

    @Override
    public boolean isMatch(String url) {
        return this.tinyFilterConfig.isMatch(url);
    }

    @Override
    public WebContext wrapContext(WebContext wrappedContext) {
        WebContext context = this.getAlreadyWrappedContext(wrappedContext);
        this.initContext(context);
        return context;
    }

    protected void initContext(WebContext context) {
    }

    protected WebContext getAlreadyWrappedContext(WebContext wrappedContext) {
        return new DefaultWebContext(wrappedContext);
    }

    protected String get(String param) {
        return this.tinyFilterConfig.getInitParameter(param);
    }

    public int getOrder() {
        return 0;
    }
}

