/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.application.impl.ApplicationDefault;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.config.ConfigurationManager;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.FileResolverFactory;
import org.tinygroup.fileresolver.FileResolverUtil;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.fileresolver.impl.ConfigurationFileProcessor;
import org.tinygroup.fileresolver.impl.LocalPropertiesFileProcessor;
import org.tinygroup.fileresolver.impl.MergePropertiesFileProcessor;
import org.tinygroup.loader.LoaderManager;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.PathFilter;
import org.tinygroup.remoteconfig.RemoteConfigReadClient;
import org.tinygroup.remoteconfig.utils.RemoteConfigHandler;
import org.tinygroup.springmerge.beanfactory.SpringMergeApplicationContext;
import org.tinygroup.springutil.ExtendsSpringBeanContainer;
import org.tinygroup.springutil.fileresolver.SpringBeansFileProcessor;
import org.tinygroup.vfs.VFS;
import org.tinygroup.weblayer.configmanager.TinyListenerConfigManagerHolder;
import org.tinygroup.weblayer.listener.ServletContextHolder;
import org.tinygroup.weblayer.listener.TinyServletContext;
import org.tinygroup.weblayer.util.TinyConfigParamUtil;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;
import org.tinygroup.xstream.XStreamFactory;

public class ApplicationStartupListener
implements ServletContextListener {
    public static final String TINY_SPRING_CONTAINER_KEY = "tinySpringContainer";
    private static Logger logger = LoggerFactory.getLogger(ApplicationStartupListener.class);
    private Application application = null;

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u505c\u6b62\u4e2d...");
        if (this.application != null) {
            this.application.stop();
        }
        this.destroyContextListener(servletContextEvent);
        ConfigurationUtil.clear();
        ServletContextHolder.getServletContext().removeAttribute(TINY_SPRING_CONTAINER_KEY);
        ServletContextHolder.clear();
        logger.logMessage(LogLevel.INFO, "\u5173\u95edspring\u5bb9\u5668\u5f00\u59cb");
        ExtendsSpringBeanContainer container = (ExtendsSpringBeanContainer)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader());
        container.clear();
        logger.logMessage(LogLevel.INFO, "\u5173\u95edspring\u5bb9\u5668\u7ed3\u675f");
        BeanContainerFactory.destroy();
        FileResolverFactory.destroyFileResolver();
        logger.logMessage(LogLevel.INFO, "WEB \u8fdc\u7a0b\u914d\u7f6e\u505c\u6b62\u4e2d...");
        TinyConfigParamUtil.setReadClient(null);
        logger.logMessage(LogLevel.INFO, "WEB \u8fdc\u7a0b\u914d\u7f6e\u505c\u6b62\u5b8c\u6210\u3002");
        VFS.clearCache();
        LoggerFactory.clearAllLoggers();
        LoaderManager.clear();
        XStreamFactory.clear();
        LogFactory.release((ClassLoader)Thread.currentThread().getContextClassLoader());
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u505c\u6b62\u5b8c\u6210\u3002");
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        TinyServletContext servletContext = new TinyServletContext(servletContextEvent.getServletContext());
        ServletContextHolder.setServletContext(servletContext);
        Enumeration enumeration = servletContextEvent.getServletContext().getAttributeNames();
        logger.logMessage(LogLevel.INFO, "WEB\u73af\u5883\u5c5e\u6027\u5f00\u59cb");
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            logger.logMessage(LogLevel.INFO, "{0}=[{1}]", new Object[]{key, servletContextEvent.getServletContext().getAttribute(key)});
        }
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u542f\u52a8\u4e2d...");
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u4fe1\u606f\uff1a[{0}]", new Object[]{servletContextEvent.getServletContext().getServerInfo()});
        String webRootPath = servletContextEvent.getServletContext().getRealPath("/");
        if (webRootPath == null) {
            try {
                webRootPath = servletContextEvent.getServletContext().getResource("/").getFile();
            }
            catch (MalformedURLException e) {
                logger.errorMessage("\u83b7\u53d6WEBROOT\u5931\u8d25\uff01", (Throwable)e, new Object[0]);
            }
        }
        logger.logMessage(LogLevel.INFO, "TINY_WEBROOT\uff1a[{0}]", new Object[]{webRootPath});
        ConfigurationUtil.getConfigurationManager().setConfiguration("TINY_WEBROOT", webRootPath);
        logger.logMessage(LogLevel.INFO, "\u5e94\u7528\u53c2\u6570<TINY_WEBROOT>=<{}>", new Object[]{webRootPath});
        logger.logMessage(LogLevel.INFO, "ServerContextName\uff1a[{0}]", new Object[]{servletContextEvent.getServletContext().getServletContextName()});
        logger.logMessage(LogLevel.INFO, "WEB\u73af\u5883\u5c5e\u6027\u7ed3\u675f");
        InputStream inputStream = this.getClass().getResourceAsStream("/application.xml");
        if (inputStream == null) {
            try {
                File file = new File(webRootPath + "/classes/application.xml");
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                logger.errorMessage("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a\uff01", (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        if (inputStream != null) {
            String applicationConfig = "";
            try {
                List processorConfigs;
                this.application = new ApplicationDefault();
                applicationConfig = StreamUtil.readText((InputStream)inputStream, (String)"UTF-8", (boolean)true);
                if (applicationConfig != null) {
                    ConfigurationManager c = ConfigurationUtil.getConfigurationManager();
                    XmlNode applicationXml = (XmlNode)new XmlStringParser().parse(applicationConfig).getRoot();
                    c.setApplicationConfiguration(applicationXml);
                }
                this.loadProperties(applicationConfig);
                this.loadSpringBeans(applicationConfig);
                XmlNode applicationXml = ConfigurationUtil.getConfigurationManager().getApplicationConfiguration();
                if (applicationXml != null && (processorConfigs = applicationXml.getSubNodesRecursively("application-processor")) != null) {
                    for (XmlNode processorConfig : processorConfigs) {
                        String processorBean = processorConfig.getAttribute("bean");
                        ApplicationProcessor processor = (ApplicationProcessor)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(processorBean);
                        this.application.addApplicationProcessor(processor);
                    }
                }
            }
            catch (Exception e) {
                logger.errorMessage("\u8f7d\u5165\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}\uff01", (Throwable)e, new Object[]{e.getMessage()});
                throw new RuntimeException(e);
            }
            logger.logMessage(LogLevel.INFO, "\u542f\u52a8\u5e94\u7528\u5f00\u59cb...");
            this.application.init();
            this.application.start();
            FullContextFileRepository fileRepository = (FullContextFileRepository)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("fullContextFileRepository");
            servletContext.setFullContextFileRepository(fileRepository);
        }
        this.initContextListener(servletContextEvent);
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u542f\u52a8\u5b8c\u6210\u3002");
    }

    private void initContextListener(ServletContextEvent servletContextEvent) {
        List<ServletContextListener> contextListeners = TinyListenerConfigManagerHolder.getInstance().getContextListeners();
        for (ServletContextListener servletContextListener : contextListeners) {
            logger.logMessage(LogLevel.DEBUG, "ServletContextListener:[{0}] will be Initialized", new Object[]{servletContextListener});
            servletContextListener.contextInitialized(servletContextEvent);
            logger.logMessage(LogLevel.DEBUG, "ServletContextListener:[{0}] Initialized", new Object[]{servletContextListener});
        }
    }

    private void destroyContextListener(ServletContextEvent servletContextEvent) {
        List<ServletContextListener> contextListeners = TinyListenerConfigManagerHolder.getInstance().getContextListeners();
        for (ServletContextListener servletContextListener : contextListeners) {
            logger.logMessage(LogLevel.DEBUG, "ServletContextListener:[{0}] will be Destroyed", new Object[]{servletContextListener});
            servletContextListener.contextDestroyed(servletContextEvent);
            logger.logMessage(LogLevel.DEBUG, "ServletContextListener:[{0}] Destroyed", new Object[]{servletContextListener});
        }
    }

    private void loadSpringBeans(String applicationConfig) {
        logger.logMessage(LogLevel.INFO, "\u52a0\u8f7dSpring Bean\u6587\u4ef6\u5f00\u59cb...");
        BeanContainerFactory.initBeanContainer((String)ExtendsSpringBeanContainer.class.getName());
        ExtendsSpringBeanContainer beanContainer = (ExtendsSpringBeanContainer)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader());
        beanContainer.setApplicationContext(this.createWebApplicationContext());
        FileResolver fileResolver = FileResolverFactory.getFileResolver();
        FileResolverUtil.addClassPathPattern((FileResolver)fileResolver);
        this.loadFileResolverConfig(fileResolver, applicationConfig);
        List webClasses = FileResolverUtil.getWebClasses();
        fileResolver.addResolvePath(webClasses);
        logger.logMessage(LogLevel.INFO, "getWebClasses:{0}", new Object[]{webClasses});
        try {
            List webLibJars = FileResolverUtil.getWebLibJars((FileResolver)fileResolver);
            fileResolver.addResolvePath(webLibJars);
            logger.logMessage(LogLevel.INFO, "getWebLibJars:{0}", new Object[]{webLibJars});
        }
        catch (Exception e) {
            logger.errorMessage("\u4e3a\u6587\u4ef6\u626b\u63cf\u5668\u6dfb\u52a0webLibJars\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
        fileResolver.addFileProcessor((FileProcessor)new SpringBeansFileProcessor());
        fileResolver.addFileProcessor((FileProcessor)new ConfigurationFileProcessor());
        fileResolver.resolve();
        logger.logMessage(LogLevel.INFO, "\u52a0\u8f7dSpring Bean\u6587\u4ef6\u7ed3\u675f\u3002");
    }

    protected AbstractRefreshableConfigApplicationContext createWebApplicationContext() {
        BeanDefinitionRegistry mergedBeanDefinitionRegistry = this.loadMergeBeanDefinition();
        SpringMergeApplicationContext wac = new SpringMergeApplicationContext(mergedBeanDefinitionRegistry);
        wac.setServletContext(ServletContextHolder.getServletContext());
        ServletContextHolder.getServletContext().setAttribute(TINY_SPRING_CONTAINER_KEY, (Object)wac);
        return wac;
    }

    private BeanDefinitionRegistry loadMergeBeanDefinition() {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        Resource resource = resourceLoader.getResource("MERGE-INFO/merge.xml");
        Object registry = null;
        registry = resource.exists() ? new XmlBeanFactory(resource) : new DefaultListableBeanFactory();
        return registry;
    }

    private void loadFileResolverConfig(FileResolver fileResolver, String applicationConfig) {
        XmlStringParser parser = new XmlStringParser();
        XmlNode root = (XmlNode)parser.parse(applicationConfig).getRoot();
        PathFilter filter = new PathFilter((Node)root);
        XmlNode appConfig = (XmlNode)filter.findNode("/application/file-resolver-configuration");
        fileResolver.config(appConfig, null);
    }

    private void loadProperties(String applicationConfig) {
        logger.infoMessage("\u52a0\u8f7dapplication\u5e38\u91cf\u914d\u7f6e...\u5f00\u59cb", new Object[0]);
        LocalPropertiesFileProcessor localFileProcessor = new LocalPropertiesFileProcessor(applicationConfig);
        localFileProcessor.start();
        RemoteConfigReadClient client = TinyConfigParamUtil.getReadClient();
        if (client != null) {
            RemoteConfigHandler remoteConfig = new RemoteConfigHandler(applicationConfig, client);
            remoteConfig.start();
        }
        MergePropertiesFileProcessor mergeProcessor = new MergePropertiesFileProcessor();
        mergeProcessor.start();
        logger.infoMessage("\u52a0\u8f7dapplication\u5e38\u91cf\u914d\u7f6e...\u7ed3\u675f", new Object[0]);
    }
}

