/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.tinygroup.commons.io.ByteArray;
import org.tinygroup.commons.io.ByteArrayInputStream;
import org.tinygroup.commons.io.StreamUtil;

public class MultipleReadServletRequest
extends HttpServletRequestWrapper {
    private boolean acquired;
    private BufferedServletInputStream servletInputStream;

    public MultipleReadServletRequest(HttpServletRequest request) {
        super(request);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (!this.acquired) {
            ByteArray byteArray = StreamUtil.readBytes((InputStream)super.getInputStream(), (boolean)true);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray.toByteArray());
            this.servletInputStream = new BufferedServletInputStream(byteArrayInputStream);
            this.acquired = true;
        }
        this.servletInputStream.reset();
        return this.servletInputStream;
    }

    private static class BufferedServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream byteArrayInputStream;

        public BufferedServletInputStream(ByteArrayInputStream byteArrayInputStream) {
            this.byteArrayInputStream = byteArrayInputStream;
        }

        public synchronized void reset() throws IOException {
            this.byteArrayInputStream.reset();
        }

        public int read() throws IOException {
            return this.byteArrayInputStream.read();
        }

        public int read(byte[] b) throws IOException {
            return this.byteArrayInputStream.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.byteArrayInputStream.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.byteArrayInputStream.skip(n);
        }

        public int available() throws IOException {
            return this.byteArrayInputStream.available();
        }

        public void close() throws IOException {
            this.byteArrayInputStream.close();
        }

        public synchronized void mark(int readlimit) {
            this.byteArrayInputStream.mark(readlimit);
        }

        public boolean markSupported() {
            return this.byteArrayInputStream.markSupported();
        }
    }
}

