/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.weblayer.config.InitParam;

public class BasicConfigInfo {
    @XStreamAsAttribute
    private String id;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    @XStreamAlias(value="class")
    private String className;
    @XStreamAsAttribute
    @XStreamAlias(value="bean")
    private String beanName;
    @XStreamImplicit
    private List<InitParam> params;
    private transient Map<String, String> parameterMap;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public List<InitParam> getParams() {
        if (this.params == null) {
            this.params = new ArrayList<InitParam>();
        }
        return this.params;
    }

    public void setParams(List<InitParam> params) {
        this.params = params;
    }

    public String getConfigName() {
        String name = this.getName();
        if (StringUtil.isBlank((String)name)) {
            name = this.getId();
        }
        return name;
    }

    public String getConfigBeanName() {
        String beanName = this.getBeanName();
        if (StringUtil.isBlank((String)beanName)) {
            beanName = this.getClassName();
        }
        return beanName;
    }

    public String getParameterValue(String name) {
        this.initParams();
        return this.parameterMap.get(name);
    }

    public Iterator<String> getIterator() {
        this.initParams();
        return this.parameterMap.keySet().iterator();
    }

    private void initParams() {
        if (this.parameterMap == null) {
            this.parameterMap = new HashMap<String, String>();
            if (!CollectionUtil.isEmpty(this.params)) {
                for (InitParam param : this.params) {
                    this.parameterMap.put(param.getName(), param.getValue());
                }
            }
        }
    }

    public Map<String, String> getParameterMap() {
        this.initParams();
        return this.parameterMap;
    }

    public int hashCode() {
        return this.getConfigName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof BasicConfigInfo) {
            BasicConfigInfo other = (BasicConfigInfo)obj;
            return other.getConfigName().equals(this.getConfigName());
        }
        return false;
    }
}

