/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.configmanager;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.tinygroup.config.Configuration;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.config.BasicConfigInfo;
import org.tinygroup.weblayer.config.TinyListenerConfigInfo;
import org.tinygroup.weblayer.config.TinyListenerConfigInfos;
import org.tinygroup.weblayer.listener.impl.ListenerBuilderSupport;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xstream.XStreamFactory;

public class TinyListenerConfigManager
implements Configuration {
    private static final String TINY_LISTENER_NODE_PATH = "/application/tiny-listeners";
    private static Logger logger = LoggerFactory.getLogger(TinyListenerConfigManager.class);
    private Map<String, BasicConfigInfo> basicConfigMap = new HashMap<String, BasicConfigInfo>();
    private Map<String, List<BasicConfigInfo>> configMap = new HashMap<String, List<BasicConfigInfo>>();
    private ListenerBuilderSupport support = ListenerBuilderSupport.getSupportInstance();
    private XmlNode applicationConfig;
    private XmlNode componentConfig;

    public void addConfig(TinyListenerConfigInfos configInfos) {
        List<TinyListenerConfigInfo> configList = configInfos.getListenerConfigInfos();
        for (TinyListenerConfigInfo configInfo : configList) {
            this.addListenerConfig(configInfo.getServletContextListenerConfigs());
            this.addListenerConfig(configInfo.getServletContextAttributeListenerConfigs());
            this.addListenerConfig(configInfo.getServletRequestAttributeListenerConfigs());
            this.addListenerConfig(configInfo.getServletRequestListenerConfigs());
            this.addListenerConfig(configInfo.getSessionActivationListenerConfigs());
            this.addListenerConfig(configInfo.getSessionAttributeListenerConfigs());
            this.addListenerConfig(configInfo.getSessionBindingListenerConfigs());
            this.addListenerConfig(configInfo.getSessionListenerConfigs());
        }
    }

    private <T extends BasicConfigInfo> void addListenerConfig(List<T> configs) {
        for (BasicConfigInfo config : configs) {
            if (this.basicConfigMap.containsKey(config.getConfigName())) {
                logger.logMessage(LogLevel.WARN, "already exist listener name:[{0}],please reset the listener name", new Object[]{config.getConfigName()});
                continue;
            }
            this.basicConfigMap.put(config.getConfigName(), config);
            this.collectConfigByBeanName(config);
        }
    }

    private <T extends BasicConfigInfo> void removeListenerConfig(List<T> configs) {
        for (BasicConfigInfo config : configs) {
            this.basicConfigMap.remove(config.getConfigName());
            this.removeConfigByBeanName(config);
        }
    }

    private void collectConfigByBeanName(BasicConfigInfo config) {
        List<BasicConfigInfo> configInfos = this.configMap.get(config.getConfigBeanName());
        if (configInfos == null) {
            configInfos = new ArrayList<BasicConfigInfo>();
            this.configMap.put(config.getConfigBeanName(), configInfos);
        }
        configInfos.add(config);
    }

    private void removeConfigByBeanName(BasicConfigInfo config) {
        List<BasicConfigInfo> configInfos = this.configMap.get(config.getConfigBeanName());
        if (configInfos != null) {
            configInfos.remove(config);
        }
    }

    public void removeConfig(TinyListenerConfigInfos configInfos) {
        List<TinyListenerConfigInfo> configList = configInfos.getListenerConfigInfos();
        for (TinyListenerConfigInfo configInfo : configList) {
            this.removeListenerConfig(configInfo.getServletContextAttributeListenerConfigs());
            this.removeListenerConfig(configInfo.getServletContextAttributeListenerConfigs());
            this.removeListenerConfig(configInfo.getSessionActivationListenerConfigs());
            this.removeListenerConfig(configInfo.getSessionAttributeListenerConfigs());
            this.removeListenerConfig(configInfo.getSessionBindingListenerConfigs());
            this.removeListenerConfig(configInfo.getSessionListenerConfigs());
            this.removeListenerConfig(configInfo.getServletRequestAttributeListenerConfigs());
            this.removeListenerConfig(configInfo.getServletRequestListenerConfigs());
        }
    }

    public XmlNode getApplicationConfig() {
        return this.applicationConfig;
    }

    public String getApplicationNodePath() {
        return TINY_LISTENER_NODE_PATH;
    }

    public String getComponentConfigPath() {
        return "/tinylistener.config.xml";
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        this.applicationConfig = applicationConfig;
        this.componentConfig = componentConfig;
    }

    private void combineConfig(List<XmlNode> combineList) {
        XStream stream = XStreamFactory.getXStream((String)"weblayer");
        for (XmlNode xmlNode : combineList) {
            TinyListenerConfigInfos listenerConfigInfos = (TinyListenerConfigInfos)stream.fromXML(xmlNode.toString());
            this.addConfig(listenerConfigInfos);
        }
    }

    public void combineConfig() {
        ArrayList<XmlNode> combineList = new ArrayList<XmlNode>();
        if (this.componentConfig != null) {
            combineList.add(this.componentConfig);
        }
        if (this.applicationConfig != null) {
            combineList.add(this.applicationConfig);
        }
        this.combineConfig(combineList);
    }

    public XmlNode getComponentConfig() {
        return this.componentConfig;
    }

    public void newInstance() {
        this.support.listenerInstanceBuilder(this.configMap);
    }

    public List<ServletContextListener> getContextListeners() {
        return this.support.getContextListeners();
    }

    public List<ServletContextAttributeListener> getContextAttributeListeners() {
        return this.support.getContextAttributeListeners();
    }

    public List<HttpSessionListener> getSessionListeners() {
        return this.support.getSessionListeners();
    }

    public List<HttpSessionAttributeListener> getSessionAttributeListeners() {
        return this.support.getSessionAttributeListeners();
    }

    public List<HttpSessionActivationListener> getSessionActivationListeners() {
        return this.support.getSessionActivationListeners();
    }

    public List<HttpSessionBindingListener> getSessionBindingListeners() {
        return this.support.getSessionBindingListeners();
    }

    public List<ServletRequestAttributeListener> getRequestAttributeListeners() {
        return this.support.getRequestAttributeListeners();
    }

    public List<ServletRequestListener> getRequestListeners() {
        return this.support.getRequestListeners();
    }

    public void clear() {
        this.basicConfigMap.clear();
        this.configMap.clear();
        this.support.clear();
    }
}

