/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.config.TinyProcessorConfigInfos;
import org.tinygroup.weblayer.configmanager.TinyProcessorConfigManager;
import org.tinygroup.xstream.XStreamFactory;

public class TinyProcessorFileProcessor
extends AbstractFileProcessor {
    private static final String SERVLETS_EXT_FILENAMES = ".tinyprocessor.xml";
    private TinyProcessorConfigManager configManager;

    public TinyProcessorConfigManager getConfigManager() {
        return this.configManager;
    }

    public void setConfigManager(TinyProcessorConfigManager configManager) {
        this.configManager = configManager;
    }

    public void process() {
        TinyProcessorConfigInfos oldConfigs;
        XStream stream = XStreamFactory.getXStream((String)"weblayer");
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664tiny-processor\u63cf\u8ff0\u6587\u4ef6\uff1a<{}>", new Object[]{fileObject.getAbsolutePath()});
            oldConfigs = (TinyProcessorConfigInfos)this.caches.get(fileObject.getAbsolutePath());
            if (oldConfigs != null) {
                this.configManager.removeConfig(oldConfigs);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664tiny-processor\u63cf\u8ff0\u6587\u4ef6\uff1a<{}>\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            oldConfigs = (TinyProcessorConfigInfos)this.caches.get(fileObject.getAbsolutePath());
            if (oldConfigs != null) {
                this.configManager.removeConfig(oldConfigs);
            }
            LOGGER.logMessage(LogLevel.INFO, "\u627e\u5230tiny-processor\u63cf\u8ff0\u6587\u4ef6\uff1a<{}>", new Object[]{fileObject.getAbsolutePath()});
            TinyProcessorConfigInfos configInfos = (TinyProcessorConfigInfos)this.convertFromXml(stream, fileObject);
            this.configManager.addConfig(configInfos);
            this.caches.put(fileObject.getAbsolutePath(), configInfos);
        }
        if (this.changeList.size() > 0) {
            this.configManager.combineConfig();
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(SERVLETS_EXT_FILENAMES);
    }
}

