/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.weblayer.AbstractTinyFilter;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.webcontext.form.FormCheckStrategy;
import org.tinygroup.weblayer.webcontext.form.FormManager;
import org.tinygroup.weblayer.webcontext.util.WebContextUtil;

public class FormCheckTinyFilter
extends AbstractTinyFilter {
    private FormManager formManager;
    private FormCheckStrategy formCheckStrategy;
    private List<String> checkUrls = new ArrayList<String>();
    private boolean filterFormCheck;

    @Override
    public void preProcess(WebContext context) throws ServletException, IOException {
        if (this.filterFormCheck) {
            String servletPath = WebContextUtil.getServletPath(context.getRequest());
            boolean isCheck = false;
            for (String checkUrl : this.checkUrls) {
                if (!Pattern.matches(checkUrl, servletPath)) continue;
                isCheck = true;
                break;
            }
            if (isCheck) {
                this.formCheckStrategy.apply(context.getRequest(), false);
            }
        }
    }

    @Override
    public void postProcess(WebContext context) throws ServletException, IOException {
        HttpServletRequest request = context.getRequest();
        String formToken = this.getFormToken(context.getRequest());
        if (this.formManager != null && formToken != null) {
            String forbidDupSubmit = request.getParameter("_form_forbid_dup");
            if (forbidDupSubmit == null) {
                forbidDupSubmit = (String)request.getAttribute("_form_forbid_dup");
            }
            if (!StringUtils.equalsIgnoreCase((String)forbidDupSubmit, (String)"n") && !StringUtils.equalsIgnoreCase((String)forbidDupSubmit, (String)"no")) {
                this.formManager.destroyToken(request, formToken);
            }
        }
    }

    protected String getFormToken(HttpServletRequest request) {
        String formToken = request.getParameter("_form_token");
        if (formToken == null) {
            formToken = (String)request.getAttribute("_form_token");
        }
        return formToken;
    }

    @Override
    protected void customInit() {
        String filterCheck;
        String checkUrlStr = this.get("check-urls");
        if (this.checkUrls == null) {
            this.checkUrls = new ArrayList<String>();
        }
        if (!StringUtil.isBlank((String)checkUrlStr)) {
            Collections.addAll(this.checkUrls, checkUrlStr.split(","));
        }
        if (!StringUtil.isBlank((String)(filterCheck = this.get("filterFormCheck")))) {
            this.filterFormCheck = Boolean.parseBoolean(filterCheck);
        }
    }

    public void setFormManager(FormManager formManager) {
        this.formManager = formManager;
    }

    public void setFormCheckStrategy(FormCheckStrategy formCheckStrategy) {
        this.formCheckStrategy = formCheckStrategy;
    }

    public void setCheckUrls(List<String> checkUrls) {
        this.checkUrls = checkUrls;
    }

    public void setFilterFormCheck(boolean filterFormCheck) {
        this.filterFormCheck = filterFormCheck;
    }
}

