/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.weblayer.TinyFilterConfig;
import org.tinygroup.weblayer.config.FilterMapping;
import org.tinygroup.weblayer.config.TinyFilterConfigInfo;
import org.tinygroup.weblayer.impl.SimpleBasicTinyConfig;
import org.tinygroup.weblayer.util.RequestURIFilter;

public class DefaultTinyFilterConfig
extends SimpleBasicTinyConfig
implements TinyFilterConfig {
    private List<String> patternStrs = new ArrayList<String>();
    private List<RequestURIFilter> requestURIFilters = new ArrayList<RequestURIFilter>();

    public DefaultTinyFilterConfig(TinyFilterConfigInfo config) {
        super(config.getConfigName(), config);
        this.setFilterConfig(config);
    }

    private void setFilterConfig(TinyFilterConfigInfo config) {
        Set<FilterMapping> filterMappings = config.getFilterMappings();
        for (FilterMapping filterMapping : filterMappings) {
            String urlPattern = filterMapping.getUrlPattern();
            if (!this.patternStrs.contains(urlPattern)) {
                this.requestURIFilters.add(new RequestURIFilter(urlPattern));
                this.patternStrs.add(urlPattern);
            }
            logger.logMessage(LogLevel.DEBUG, "<{}>\u7684url-pattern:'{}'", new Object[]{this.configName, urlPattern});
        }
    }

    @Override
    public boolean isMatch(String url) {
        for (RequestURIFilter requestURIFilter : this.requestURIFilters) {
            if (!requestURIFilter.matches(url)) continue;
            logger.logMessage(LogLevel.DEBUG, "\u8bf7\u6c42\u8def\u5f84\uff1a<{}>,\u5339\u914d\u7684tiny-filter:<{}>", new Object[]{url, this.configName});
            return true;
        }
        return false;
    }
}

