/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import org.springframework.web.util.NestedServletException;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.order.OrderUtil;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.FilterWrapper;
import org.tinygroup.weblayer.TinyFilter;
import org.tinygroup.weblayer.TinyFilterConfig;
import org.tinygroup.weblayer.TinyFilterManager;
import org.tinygroup.weblayer.config.TinyFilterConfigInfo;
import org.tinygroup.weblayer.config.TinyWrapperFilterConfigInfo;
import org.tinygroup.weblayer.configmanager.TinyFilterConfigManager;
import org.tinygroup.weblayer.impl.DefaultTinyFilterConfig;
import org.tinygroup.weblayer.impl.TinyFilterWrapper;

public class TinyFilterManagerImpl
implements TinyFilterManager {
    private static final String SPLIT_CHAR = ",";
    private static Logger logger = LoggerFactory.getLogger(TinyFilterManagerImpl.class);
    private TinyFilterConfigManager configManager;
    private List<TinyFilter> tinyFilters = new CopyOnWriteArrayList<TinyFilter>();
    private Map<String, TinyFilterConfig> filterConfigMap = new HashMap<String, TinyFilterConfig>();
    private FilterWrapper wrapper;

    @Override
    public List<TinyFilter> getTinyFiltersWithUrl(String url) {
        ArrayList<TinyFilter> filters = new ArrayList<TinyFilter>();
        for (TinyFilter tinyFilter : this.tinyFilters) {
            if (!tinyFilter.isMatch(url)) continue;
            filters.add(tinyFilter);
        }
        return filters;
    }

    @Override
    public void initTinyResources() throws ServletException {
        this.reset();
        Throwable failureCause = null;
        try {
            this.combineConfig();
            this.addWrapperFilter();
            this.addTinyFilter();
            this.initWrapperFilter();
            OrderUtil.order(this.tinyFilters);
            this.initTinyFilter();
        }
        catch (ServletException ex) {
            failureCause = ex;
            throw ex;
        }
        catch (Throwable ex) {
            failureCause = ex;
            throw new NestedServletException("filter init processing failed", ex);
        }
        finally {
            if (failureCause != null) {
                logger.errorMessage("Could not init filter", failureCause, new Object[0]);
            } else {
                logger.logMessage(LogLevel.DEBUG, "Successfully completed filter init");
            }
        }
    }

    private void combineConfig() {
        if (CollectionUtil.isEmpty(this.configManager.getFilterConfigMap())) {
            this.configManager.combineConfig();
        }
    }

    private void reset() {
        this.tinyFilters = new ArrayList<TinyFilter>();
        this.wrapper = new TinyFilterWrapper(this.configManager, this);
        this.filterConfigMap = new HashMap<String, TinyFilterConfig>();
    }

    private void initWrapperFilter() throws ServletException {
        this.wrapper.init();
    }

    private void initTinyFilter() throws ServletException {
        for (TinyFilter tinyFilter : this.tinyFilters) {
            logger.logMessage(LogLevel.DEBUG, "tiny filter name:[{0}] start init", new Object[]{tinyFilter.getFilterName()});
            TinyFilterConfigInfo configInfo = this.configManager.getFilterConfig(tinyFilter.getFilterName());
            tinyFilter.initTinyFilter(new DefaultTinyFilterConfig(configInfo));
            logger.logMessage(LogLevel.DEBUG, "tiny filter name:[{0}] init end", new Object[]{tinyFilter.getFilterName()});
        }
    }

    private void addTinyFilter() {
        List<TinyFilterConfigInfo> filterConfigs = this.configManager.getFilterConfigs();
        for (TinyFilterConfigInfo filterConfig : filterConfigs) {
            this.tinyFilters.add(this.createTinyFilter(filterConfig));
            this.filterConfigMap.put(filterConfig.getConfigName(), new DefaultTinyFilterConfig(filterConfig));
        }
    }

    private void addWrapperFilter() {
        List<TinyWrapperFilterConfigInfo> wrapperConfigs = this.configManager.getWrapperFilterConfigs();
        for (TinyWrapperFilterConfigInfo wrapperConfig : wrapperConfigs) {
            this.addWrapperFilter(wrapperConfig);
            this.filterConfigMap.put(wrapperConfig.getConfigName(), new DefaultTinyFilterConfig(wrapperConfig));
        }
    }

    private void addWrapperFilter(TinyWrapperFilterConfigInfo wrapperConfig) {
        String[] beanNameArray;
        String filterBeanName = wrapperConfig.getFilterBeanName();
        if (StringUtil.isBlank((String)filterBeanName)) {
            return;
        }
        for (String beanName : beanNameArray = filterBeanName.split(SPLIT_CHAR)) {
            Filter filter = (Filter)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(beanName);
            this.wrapper.addHttpFilter(wrapperConfig.getConfigName(), beanName, filter);
        }
    }

    private TinyFilter createTinyFilter(TinyFilterConfigInfo filterConfigInfo) {
        String filterName = filterConfigInfo.getConfigName();
        logger.logMessage(LogLevel.INFO, "tiny-filter:{}\u5f00\u59cb\u88ab\u5b9e\u4f8b\u5316", new Object[]{filterName});
        TinyFilter filter = this.instanceFilter(filterConfigInfo.getConfigBeanName());
        filter.setFilterName(filterName);
        logger.logMessage(LogLevel.INFO, "tiny-filter:{}\u5b9e\u4f8b\u5316\u7ed3\u675f", new Object[]{filterName});
        return filter;
    }

    private TinyFilter instanceFilter(String beanName) {
        TinyFilter filter = (TinyFilter)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(beanName);
        return filter;
    }

    @Override
    public void destoryTinyResources() {
        for (TinyFilter tinyFilter : this.tinyFilters) {
            tinyFilter.destroyTinyFilter();
        }
        this.tinyFilters = null;
        this.wrapper = null;
    }

    @Override
    public void setConfigManager(TinyFilterConfigManager configManager) {
        this.configManager = configManager;
    }

    @Override
    public boolean existFilterWrapper() {
        return this.wrapper != null;
    }

    @Override
    public FilterWrapper getFilterWrapper() {
        return this.wrapper;
    }

    @Override
    public TinyFilterConfig getTinyFilterConfig(String filterName) {
        return this.filterConfigMap.get(filterName);
    }
}

