/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.FilterHandler;
import org.tinygroup.weblayer.FilterWrapper;
import org.tinygroup.weblayer.TinyFilterConfig;
import org.tinygroup.weblayer.TinyFilterManager;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.config.TinyFilterConfigInfo;
import org.tinygroup.weblayer.configmanager.TinyFilterConfigManager;
import org.tinygroup.weblayer.impl.TinyFilterChain;
import org.tinygroup.weblayer.impl.TinyWrapperFilterConfig;

public class TinyFilterWrapper
implements FilterWrapper {
    private static final Logger logger = LoggerFactory.getLogger(TinyFilterWrapper.class);
    private Map<String, Filter> filterMap = new TreeMap<String, Filter>();
    private Map<String, String> bean2Config = new HashMap<String, String>();
    private TinyFilterConfigManager tinyFilterConfigManager;
    private TinyFilterManager tinyFilterManager;

    public TinyFilterWrapper(TinyFilterConfigManager tinyFilterConfigManager, TinyFilterManager tinyFilterManager) {
        this.tinyFilterConfigManager = tinyFilterConfigManager;
        this.tinyFilterManager = tinyFilterManager;
    }

    @Override
    public void filterWrapper(WebContext context, FilterHandler handler) throws IOException, ServletException {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        String servletPath = handler.getServletPath();
        List<Filter> matchFilters = this.getMatchFilters(servletPath, this.filterMap);
        logger.logMessage(LogLevel.DEBUG, "the pre wrapper httpFilters for the request path:[{0}] is [{1}]", new Object[]{servletPath, matchFilters});
        TinyFilterChain filterChain = new TinyFilterChain(matchFilters, handler);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private List<Filter> getMatchFilters(String servletPath, Map<String, Filter> filterMap) {
        ArrayList<Filter> matchFilters = new ArrayList<Filter>();
        for (String filterBeanName : filterMap.keySet()) {
            TinyFilterConfig filterConfig = this.tinyFilterManager.getTinyFilterConfig(this.bean2Config.get(filterBeanName));
            if (!filterConfig.isMatch(servletPath)) continue;
            matchFilters.add(filterMap.get(filterBeanName));
        }
        return matchFilters;
    }

    @Override
    public void addHttpFilter(String filterName, String filterBeanName, Filter filter) {
        this.filterMap.put(filterBeanName, filter);
        this.bean2Config.put(filterBeanName, filterName);
    }

    @Override
    public void init() throws ServletException {
        logger.logMessage(LogLevel.DEBUG, "TinyFilterWrapper start initialization wrapper httpfilter");
        this.initWrapperFilters(this.filterMap);
        logger.logMessage(LogLevel.DEBUG, "TinyFilterWrapper initialization end");
    }

    private void initWrapperFilters(Map<String, Filter> filterMap) throws ServletException {
        for (String filterBeanName : filterMap.keySet()) {
            Filter filter = filterMap.get(filterBeanName);
            TinyFilterConfigInfo filterConfigInfo = this.tinyFilterConfigManager.getFilterConfig(this.bean2Config.get(filterBeanName));
            filter.init((FilterConfig)new TinyWrapperFilterConfig(filterConfigInfo));
        }
    }

    @Override
    public void destroy() {
        this.filterMap = null;
    }
}

