/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.listener.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.tinygroup.commons.order.Ordered;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.listener.ListenerInstanceBuilder;

public abstract class AbstractListenerBuilder<INSTANCE>
implements ListenerInstanceBuilder<INSTANCE> {
    private static Logger logger = LoggerFactory.getLogger(AbstractListenerBuilder.class);
    protected List<INSTANCE> listeners = Collections.synchronizedList(new ArrayList());
    private boolean ordered;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildInstances(INSTANCE object) {
        INSTANCE listener = object;
        if (!this.imptOrdered(object)) {
            listener = this.replaceListener(object);
            logger.logMessage(LogLevel.DEBUG, "listener:[{0}] not implements Ordered will replace [{1}]", new Object[]{object.getClass().getSimpleName(), listener.getClass().getSimpleName()});
        }
        List<INSTANCE> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    protected abstract INSTANCE replaceListener(INSTANCE var1);

    private boolean imptOrdered(Object object) {
        return object instanceof Ordered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<INSTANCE> getInstances() {
        List<INSTANCE> list = this.listeners;
        synchronized (list) {
            if (!this.ordered) {
                Collections.sort(this.listeners, new Comparator<INSTANCE>(){

                    @Override
                    public int compare(INSTANCE o1, INSTANCE o2) {
                        Ordered order1 = (Ordered)o1;
                        Ordered order2 = (Ordered)o2;
                        if (order1 != null && order2 != null) {
                            return order1.getOrder() > order2.getOrder() ? 1 : (order1.getOrder() == order2.getOrder() ? 0 : -1);
                        }
                        return 0;
                    }
                });
                this.ordered = true;
            }
        }
        return this.listeners;
    }

    @Override
    public void clear() {
        this.listeners.clear();
    }
}

