/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.listener.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.weblayer.BasicTinyConfigAware;
import org.tinygroup.weblayer.config.BasicConfigInfo;
import org.tinygroup.weblayer.impl.SimpleBasicTinyConfig;
import org.tinygroup.weblayer.listener.ListenerInstanceBuilder;
import org.tinygroup.weblayer.listener.impl.RequestAttributeListenerBuilder;
import org.tinygroup.weblayer.listener.impl.RequestListenerBuilder;
import org.tinygroup.weblayer.listener.impl.ServletContextAttributeListenerBuilder;
import org.tinygroup.weblayer.listener.impl.ServletContextListenerBuilder;
import org.tinygroup.weblayer.listener.impl.SessionActivationListenerBuilder;
import org.tinygroup.weblayer.listener.impl.SessionAttributeListenerBuilder;
import org.tinygroup.weblayer.listener.impl.SessionBindingListenerBuilder;
import org.tinygroup.weblayer.listener.impl.SessionListenerBuilder;

public class ListenerBuilderSupport {
    private List<ListenerInstanceBuilder> builders = new ArrayList<ListenerInstanceBuilder>();
    private ListenerInstanceBuilder<ServletContextListener> contextListenerBuilder = new ServletContextListenerBuilder();
    private ListenerInstanceBuilder<ServletContextAttributeListener> contextAttributeListenerBuilder = new ServletContextAttributeListenerBuilder();
    private ListenerInstanceBuilder<HttpSessionListener> sessionListenerBuilder = new SessionListenerBuilder();
    private ListenerInstanceBuilder<HttpSessionBindingListener> sessionBindingListenerBuilder = new SessionBindingListenerBuilder();
    private ListenerInstanceBuilder<HttpSessionAttributeListener> sessionAttributeListenerBuilder = new SessionAttributeListenerBuilder();
    private ListenerInstanceBuilder<HttpSessionActivationListener> sessionActivationListenerBuilder = new SessionActivationListenerBuilder();
    private ListenerInstanceBuilder<ServletRequestListener> requestListenerBuilder = new RequestListenerBuilder();
    private ListenerInstanceBuilder<ServletRequestAttributeListener> requestAttributeListenerBuilder = new RequestAttributeListenerBuilder();

    private ListenerBuilderSupport() {
        this.builders.add(this.contextListenerBuilder);
        this.builders.add(this.contextAttributeListenerBuilder);
        this.builders.add(this.sessionListenerBuilder);
        this.builders.add(this.sessionBindingListenerBuilder);
        this.builders.add(this.sessionAttributeListenerBuilder);
        this.builders.add(this.sessionActivationListenerBuilder);
        this.builders.add(this.requestListenerBuilder);
        this.builders.add(this.requestAttributeListenerBuilder);
    }

    public static ListenerBuilderSupport getSupportInstance() {
        return new ListenerBuilderSupport();
    }

    public void listenerInstanceBuilder(Map<String, List<BasicConfigInfo>> configMap) {
        for (String beanName : configMap.keySet()) {
            List<BasicConfigInfo> configInfos = configMap.get(beanName);
            Object listener = BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(beanName);
            if (listener instanceof BasicTinyConfigAware) {
                ((BasicTinyConfigAware)listener).setBasicConfig(new SimpleBasicTinyConfig(configInfos));
            }
            for (ListenerInstanceBuilder builder : this.builders) {
                if (!builder.isTypeMatch(listener)) continue;
                builder.buildInstances(listener);
            }
        }
    }

    public List<ServletContextListener> getContextListeners() {
        return this.contextListenerBuilder.getInstances();
    }

    public List<ServletContextAttributeListener> getContextAttributeListeners() {
        return this.contextAttributeListenerBuilder.getInstances();
    }

    public List<HttpSessionListener> getSessionListeners() {
        return this.sessionListenerBuilder.getInstances();
    }

    public List<HttpSessionAttributeListener> getSessionAttributeListeners() {
        return this.sessionAttributeListenerBuilder.getInstances();
    }

    public List<HttpSessionActivationListener> getSessionActivationListeners() {
        return this.sessionActivationListenerBuilder.getInstances();
    }

    public List<HttpSessionBindingListener> getSessionBindingListeners() {
        return this.sessionBindingListenerBuilder.getInstances();
    }

    public List<ServletRequestAttributeListener> getRequestAttributeListeners() {
        return this.requestAttributeListenerBuilder.getInstances();
    }

    public List<ServletRequestListener> getRequestListeners() {
        return this.requestListenerBuilder.getInstances();
    }

    public void clear() {
        for (ListenerInstanceBuilder listenerInstanceBuilder : this.builders) {
            listenerInstanceBuilder.clear();
        }
        this.builders.clear();
    }
}

