/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.tinyprocessor;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.AbstractTinyProcessor;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.impl.TinyServletConfig;

public class TinyProcessorWapper
extends AbstractTinyProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TinyProcessorWapper.class);
    private HttpServlet servlet;

    @Override
    public void reallyProcess(String urlString, WebContext context) throws ServletException, IOException {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        this.servlet.service((ServletRequest)request, (ServletResponse)response);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.servlet.destroy();
    }

    @Override
    protected void customInit() throws ServletException {
        String servletBeanName = this.get("servlet_bean");
        if (StringUtil.isBlank((String)servletBeanName)) {
            logger.logMessage(LogLevel.ERROR, "servlet_bean attribute value must not  be empty");
            throw new RuntimeException("servlet_bean attribute value must not be empty");
        }
        this.servlet = (HttpServlet)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(servletBeanName);
        if (this.servlet != null) {
            TinyServletConfig servletConfig = new TinyServletConfig();
            servletConfig.setInitParams(this.getInitParamMap());
            servletConfig.setServletConfig(this.servlet.getServletConfig());
            this.servlet.init((ServletConfig)servletConfig);
        }
    }
}

