/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.util;

import java.util.LinkedList;
import java.util.regex.Pattern;
import org.tinygroup.commons.tools.BasicConstant;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.commons.tools.ToStringBuilder;

public class RequestURIFilter {
    public static final String EXCLUDE_PREFIX = "!";
    private final String[] uris;
    private final boolean[] excludes;
    private final Pattern[] patterns;

    public RequestURIFilter(String uris) {
        LinkedList names = CollectionUtil.createLinkedList();
        LinkedList excludes = CollectionUtil.createLinkedList();
        LinkedList patterns = CollectionUtil.createLinkedList();
        for (String uri : StringUtil.split((String)StringUtil.defaultIfBlank((String)uris, (String)""), (String)", \r\n")) {
            if ((uri = StringUtil.trimToNull((String)uri)) == null) continue;
            String fullUri = uri;
            boolean exclude = uri.startsWith(EXCLUDE_PREFIX);
            if (exclude) {
                uri = StringUtil.trimToNull((String)uri.substring(EXCLUDE_PREFIX.length()));
            }
            if (uri == null) continue;
            names.add(fullUri);
            excludes.add(exclude);
            patterns.add(Pattern.compile(uri));
        }
        if (!patterns.isEmpty()) {
            this.uris = names.toArray(new String[names.size()]);
            this.patterns = patterns.toArray(new Pattern[patterns.size()]);
            this.excludes = new boolean[excludes.size()];
            for (int i = 0; i < excludes.size(); ++i) {
                this.excludes[i] = (Boolean)excludes.get(i);
            }
        } else {
            this.uris = BasicConstant.EMPTY_STRING_ARRAY;
            this.excludes = BasicConstant.EMPTY_BOOLEAN_ARRAY;
            this.patterns = null;
        }
    }

    public boolean matches(String path) {
        int i;
        if (this.patterns != null && (i = 0) < this.patterns.length) {
            boolean exclude = this.excludes[i];
            boolean find = this.patterns[i].matcher(path).find();
            if (exclude) {
                return !find;
            }
            return find;
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder().append((Object)"FilterOf").append((Object)this.uris).toString();
    }
}

