/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.basic.impl;

import javax.servlet.http.HttpServletResponse;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.HumanReadableSize;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.webcontext.AbstractWebContextWrapper;
import org.tinygroup.weblayer.webcontext.WebContextException;
import org.tinygroup.weblayer.webcontext.basic.BasicWebContext;
import org.tinygroup.weblayer.webcontext.basic.interceptor.ResponseHeaderSecurityFilter;
import org.tinygroup.weblayer.webcontext.basic.response.BasicResponseImpl;

public class BasicWebContextImpl
extends AbstractWebContextWrapper
implements BasicWebContext {
    private Object[] interceptors;
    private String maxCookieSize;

    public BasicWebContextImpl(WebContext wrappedContext) {
        super(wrappedContext);
    }

    public String getMaxCookieSize() {
        return this.maxCookieSize;
    }

    public void setMaxCookieSize(String maxSetCookieSize) {
        this.maxCookieSize = maxSetCookieSize;
    }

    @Override
    public Object[] getResponseHeaderInterceptors() {
        return (Object[])this.interceptors.clone();
    }

    @Override
    public void commitHeaders() throws WebContextException {
        ((BasicResponseImpl)this.getResponse()).commitHeaders();
    }

    public void prepareResponse() {
        ((BasicResponseImpl)this.getResponse()).prepareResponse();
    }

    public void commitResponse() {
        ((BasicResponseImpl)this.getResponse()).commitResponse();
    }

    private Object[] addDefaultInterceptors(Object[] interceptors) {
        ResponseHeaderSecurityFilter defaultInterceotor = new ResponseHeaderSecurityFilter();
        if (this.maxCookieSize != null) {
            defaultInterceotor.setMaxCookieSize(new HumanReadableSize(this.maxCookieSize));
        }
        if (ArrayUtil.isEmptyArray((Object)interceptors)) {
            return new Object[]{defaultInterceotor};
        }
        for (Object interceptor : interceptors) {
            if (!(interceptor instanceof ResponseHeaderSecurityFilter)) continue;
            return interceptors;
        }
        Object[] newInterceptors = new Object[interceptors.length + 1];
        System.arraycopy(interceptors, 0, newInterceptors, 0, interceptors.length);
        newInterceptors[interceptors.length] = defaultInterceotor;
        return newInterceptors;
    }

    public void initContext(Object[] interceptors) {
        this.interceptors = this.addDefaultInterceptors(interceptors);
        this.setResponse((HttpServletResponse)new BasicResponseImpl(this, this.getWrappedWebContext().getResponse(), this.interceptors));
    }
}

