/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.form.impl;

import javax.servlet.http.HttpServletRequest;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.webcontext.form.Form;
import org.tinygroup.weblayer.webcontext.form.FormCheckStrategy;
import org.tinygroup.weblayer.webcontext.form.FormManager;
import org.tinygroup.weblayer.webcontext.form.exception.DuplicateFormSubmitException;
import org.tinygroup.weblayer.webcontext.form.exception.FormDataJuggledException;

public abstract class AbstractFormCheckStrategy
implements FormCheckStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFormCheckStrategy.class);
    private FormManager formManager;

    @Override
    public void apply(HttpServletRequest request, boolean isModifiedCheck) {
        Form formImpl;
        String uri;
        String formToken = this.getFormToken(request);
        if (!this.applyIfTokenValue(formToken)) {
            return;
        }
        if (!this.formManager.hasForm(request, formToken)) {
            throw new DuplicateFormSubmitException("\u8868\u5355\u91cd\u590d\u63d0\u4ea4\uff0c\u4ee4\u724c[" + formToken + "]");
        }
        if (isModifiedCheck && !(uri = request.getRequestURI().toString()).equalsIgnoreCase((formImpl = this.formManager.getForm(request, formToken)).getUrl())) {
            throw new DuplicateFormSubmitException("\u5173\u952e\u5c5e\u6027\u88ab\u7be1\u6539\uff0c\u4ee4\u724c[" + formToken + "]");
        }
        if (this.formManager.isModified(request, formToken)) {
            LOGGER.logMessage(LogLevel.WARN, "\u8868\u5355:[{0}]\u7684\u6570\u636e\u88ab\u7be1\u6539\u4e86\uff0c\u672c\u6b21\u8bf7\u6c42\u53c2\u6570\uff1a{1}", new Object[]{this.formManager.dumpForm(request, formToken), request.getQueryString()});
            throw new FormDataJuggledException("\u8868\u5355\u6570\u636e\u88ab\u7be1\u6539\u4e86");
        }
    }

    protected String getFormToken(HttpServletRequest request) {
        String formToken = request.getParameter("_form_token");
        if (formToken == null) {
            formToken = (String)request.getAttribute("_form_token");
        }
        return formToken;
    }

    protected abstract boolean applyIfTokenValue(String var1);

    public void setFormManager(FormManager formManager) {
        this.formManager = formManager;
    }
}

