/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.form.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.tinygroup.weblayer.webcontext.form.Form;
import org.tinygroup.weblayer.webcontext.form.FormManager;

public class FormManagerImpl
implements FormManager {
    private static final String SESSION_KEY_OF_FROMS = "_forms_in_session_token";
    private int maxFormNum = 30;

    @Override
    public void destroyToken(HttpServletRequest request, String token) {
        this.getForms(request).remove(token);
    }

    @Override
    public String dumpForm(HttpServletRequest request, String token) {
        Form form = this.getForms(request).get(token);
        if (form == null) {
            return "null";
        }
        return form.toString();
    }

    @Override
    public boolean hasForm(HttpServletRequest request, String token) {
        if (token == null) {
            return false;
        }
        return this.getForms(request).containsKey(token);
    }

    @Override
    public boolean hasFormToken(HttpServletRequest request) {
        String formToken = request.getParameter("_form_token");
        return StringUtils.isNotBlank((String)formToken);
    }

    @Override
    public boolean isModified(HttpServletRequest request, String token) {
        boolean flag = false;
        Form form = this.getForm(request, token);
        if (form != null) {
            Map<String, String> oldParams = form.getFields();
            Map<String, String> newParams = this.getNamedParameters(request, oldParams.keySet().toArray(new String[oldParams.size()]));
            for (String key : oldParams.keySet()) {
                String oldValue;
                String newValue = StringUtils.defaultString((String)newParams.get(key));
                if (StringUtils.equals((String)newValue, (String)(oldValue = StringUtils.defaultString((String)oldParams.get(key))))) continue;
                flag = true;
                break;
            }
        } else {
            flag = true;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Form newForm(HttpServletRequest request) {
        Map<String, Form> forms;
        Form form = new Form(RandomStringUtils.randomAlphanumeric((int)32));
        Map<String, Form> map = forms = this.getForms(request);
        synchronized (map) {
            if (forms.size() >= this.maxFormNum) {
                this.removeOldestForm(request);
            }
            forms.put(form.getToken(), form);
        }
        return form;
    }

    public Form newForm(HttpServletRequest request, String url) {
        Form form = this.newForm(request);
        form.setUrl(url);
        return form;
    }

    @Override
    public Form getForm(HttpServletRequest request, String formToken) {
        Map<String, Form> formsInSession = this.getForms(request);
        return formsInSession.get(formToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Form> getForms(HttpServletRequest request) {
        HttpSession session;
        HashMap<String, Form> formsInSession = null;
        HttpSession httpSession = session = request.getSession();
        synchronized (httpSession) {
            formsInSession = (HashMap<String, Form>)session.getAttribute(SESSION_KEY_OF_FROMS);
            if (formsInSession == null) {
                formsInSession = new HashMap<String, Form>();
                session.setAttribute(SESSION_KEY_OF_FROMS, formsInSession);
            }
        }
        return formsInSession;
    }

    protected Map<String, String> getNamedParameters(HttpServletRequest request, String[] names) {
        Map parameters = request.getParameterMap();
        HashMap<String, String> params = new HashMap<String, String>();
        for (String name : names) {
            Object[] value = (String[])parameters.get(name);
            params.put(name, StringUtils.join((Object[])value, (String)"|"));
        }
        return params;
    }

    protected void removeOldestForm(HttpServletRequest request) {
        ArrayList<Form> forms = new ArrayList<Form>(this.getForms(request).values());
        if (forms.isEmpty()) {
            return;
        }
        Form oldestForm = (Form)forms.get(0);
        for (Form form : forms) {
            if (!form.getCreateTime().before(oldestForm.getCreateTime())) continue;
            oldestForm = form;
        }
        this.destroyToken(request, oldestForm.getToken());
    }

    public void setMaxFormNum(int maxFormNum) {
        this.maxFormNum = maxFormNum;
    }
}

