/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.InitializingBean;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.beanwrapper.BeanWrapperHolder;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.config.impl.AbstractConfiguration;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.weblayer.webcontext.parser.upload.ParameterParserFilter;
import org.tinygroup.weblayer.webcontext.parser.upload.UploadService;
import org.tinygroup.xmlparser.node.XmlNode;

public class ParserConfiguration
extends AbstractConfiguration {
    private static final String PARSER_CONFIG = "/application/parser";
    private static final String PROPERTY_EDITOR = "property-editor";
    private static final String PARAM_PARSER_FILTER = "param-parser-filter";
    private static final String UPLOAD_SERVICE = "upload-service";
    private static final String BEAN_NAME = "bean-name";
    private static final String PROPERTY = "property";
    private BeanWrapperImpl beanWrapper;
    private PropertyEditorRegistrar[] propertyEditors;
    private ParameterParserFilter[] parserFilters;
    private UploadService uploadService;

    public String getApplicationNodePath() {
        return PARSER_CONFIG;
    }

    public String getComponentConfigPath() {
        return null;
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        super.config(applicationConfig, componentConfig);
        if (applicationConfig != null) {
            this.beanWrapper = (BeanWrapperImpl)BeanWrapperHolder.getInstance().getBeanWrapper();
            this.resolvePropertyEditors(applicationConfig);
            this.resolverParserFilters(applicationConfig);
            this.resolverUploadService(applicationConfig);
        }
    }

    public PropertyEditorRegistrar[] getPropertyEditors() {
        return this.propertyEditors;
    }

    public ParameterParserFilter[] getParserFilters() {
        return this.parserFilters;
    }

    public UploadService getUploadService() {
        return this.uploadService;
    }

    private void resolverUploadService(XmlNode applicationConfig) {
        NameFilter nameFilter = new NameFilter((Node)applicationConfig);
        XmlNode subNode = (XmlNode)nameFilter.findNode(UPLOAD_SERVICE);
        if (subNode != null) {
            this.uploadService = (UploadService)this.wrapperObject(subNode);
        }
    }

    private void resolverParserFilters(XmlNode applicationConfig) {
        NameFilter nameFilter = new NameFilter((Node)applicationConfig);
        List subNodes = nameFilter.findNodeList(PARAM_PARSER_FILTER);
        if (!CollectionUtil.isEmpty((Collection)subNodes)) {
            this.parserFilters = (ParameterParserFilter[])Array.newInstance(ParameterParserFilter.class, subNodes.size());
            for (int i = 0; i < subNodes.size(); ++i) {
                ParameterParserFilter parserFilter;
                XmlNode xmlNode = (XmlNode)subNodes.get(i);
                String beanName = xmlNode.getAttribute(BEAN_NAME);
                this.parserFilters[i] = parserFilter = (ParameterParserFilter)BeanContainerFactory.getBeanContainer((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getBean(beanName);
            }
        }
    }

    private void resolvePropertyEditors(XmlNode applicationConfig) {
        NameFilter nameFilter = new NameFilter((Node)applicationConfig);
        List subNodes = nameFilter.findNodeList(PROPERTY_EDITOR);
        if (!CollectionUtil.isEmpty((Collection)subNodes)) {
            this.propertyEditors = (PropertyEditorRegistrar[])Array.newInstance(PropertyEditorRegistrar.class, subNodes.size());
            for (int i = 0; i < subNodes.size(); ++i) {
                XmlNode xmlNode = (XmlNode)subNodes.get(i);
                this.propertyEditors[i] = (PropertyEditorRegistrar)this.wrapperObject(xmlNode);
            }
        }
    }

    private Object wrapperObject(XmlNode xmlNode) {
        String beanName = xmlNode.getAttribute(BEAN_NAME);
        Object object = BeanContainerFactory.getBeanContainer((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getBean(beanName);
        HashMap properties = CollectionUtil.createHashMap();
        NameFilter propertyFilter = new NameFilter((Node)xmlNode);
        List subNodes = propertyFilter.findNodeList(PROPERTY);
        for (XmlNode subNode : subNodes) {
            String value = subNode.getAttribute("value");
            if (value == null) {
                value = subNode.getContent();
            }
            properties.put(subNode.getAttribute("name"), value);
        }
        this.setAttribute(object, properties);
        return object;
    }

    private void setAttribute(Object object, Map<String, String> properties) {
        this.beanWrapper.setWrappedInstance(object);
        for (String attribute : properties.keySet()) {
            try {
                String value = properties.get(attribute);
                this.beanWrapper.setPropertyValue(attribute, (Object)value);
            }
            catch (Exception e) {
                throw new RuntimeException("\u8bbe\u7f6e\u5bf9\u8c61\u5c5e\u6027\u51fa\u73b0\u5f02\u5e38", e);
            }
        }
        if (object instanceof InitializingBean) {
            try {
                ((InitializingBean)object).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new RuntimeException("initializingBean error", e);
            }
        }
    }
}

