/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.fileupload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.IOUtils;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.webcontext.parser.fileupload.DeferredByteOutputStream;
import org.tinygroup.weblayer.webcontext.parser.fileupload.FileItemStorage;

public class TinyFileItem
implements FileItem {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final long serialVersionUID = -237775327152222987L;
    private String fieldName;
    private String contentType;
    private boolean isFormField;
    private String fileName;
    private byte[] cachedContent;
    private long size = -1L;
    private DeferredByteOutputStream dbos;
    private int sizeThreshold;
    private String charset;
    private FileItemStorage storage;
    private FileObject fileObject;

    public TinyFileItem(String fieldName, String contentType, boolean isFormField, String fileName, FileItemStorage storage) {
        this.fieldName = fieldName;
        this.contentType = contentType;
        this.isFormField = isFormField;
        this.fileName = fileName;
        this.storage = storage;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.isInMemory()) {
            return new ByteArrayInputStream(this.dbos.getFileData());
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.dbos.getMemoryData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.fileName;
    }

    public boolean isInMemory() {
        return this.isFormField;
    }

    public long getSize() {
        if (this.size >= 0L) {
            return this.size;
        }
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        if (this.dbos.isInMemory()) {
            return this.dbos.getMemoryData().length;
        }
        return this.dbos.getByteCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get() {
        if (this.isInMemory()) {
            if (this.cachedContent == null) {
                this.cachedContent = this.dbos.getMemoryData();
            }
            return this.cachedContent;
        }
        byte[] fileData = new byte[(int)this.getSize()];
        ByteArrayInputStream byteInStream = null;
        try {
            byteInStream = new ByteArrayInputStream(this.dbos.getFileData());
            byteInStream.read(fileData);
        }
        catch (IOException e) {
            fileData = null;
        }
        finally {
            if (byteInStream != null) {
                try {
                    byteInStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return fileData;
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return new String(this.get(), encoding);
    }

    public String getString() {
        byte[] rawdata = this.get();
        String charset = null;
        if (this.isFormField()) {
            charset = this.getCharset();
        }
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        try {
            return new String(rawdata, charset);
        }
        catch (UnsupportedEncodingException e) {
            try {
                return new String(rawdata, DEFAULT_CHARSET);
            }
            catch (UnsupportedEncodingException ee) {
                return new String(rawdata);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws Exception {
        if (file != null) {
            file.getParentFile().mkdirs();
        }
        if (this.isInMemory()) {
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(file);
                fout.write(this.get());
            }
            finally {
                if (fout != null) {
                    fout.close();
                }
            }
        }
        this.size = this.dbos.getByteCount();
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            in = new BufferedInputStream(new ByteArrayInputStream(this.dbos.getFileData()));
            out = new BufferedOutputStream(new FileOutputStream(file));
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void storage() {
        if (this.storage != null && !this.isInMemory()) {
            this.fileObject = this.storage.storage(this);
        }
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public void delete() {
        this.cachedContent = null;
        this.dbos.clearData();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String name) {
        this.fieldName = name;
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public void setFormField(boolean state) {
        this.isFormField = state;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.dbos == null) {
            if (this.isFormField()) {
                this.sizeThreshold = Integer.MAX_VALUE;
            }
            this.dbos = new DeferredByteOutputStream(this.sizeThreshold);
        }
        return this.dbos;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String toString() {
        return StringUtil.defaultIfEmpty((String)this.getName(), (String)this.getString());
    }
}

