/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.server.UID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemHeadersSupport;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.weblayer.webcontext.parser.upload.FileUploadReName;

public abstract class AbstractFileItem
implements FileItem,
FileItemHeadersSupport {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final long serialVersionUID = 486705336474235297L;
    private static final String UID = new UID().toString().replace(':', '_').replace('-', '_');
    protected transient DeferredFileOutputStream dfos;
    private String fieldName;
    private String contentType;
    private boolean isFormField;
    private String fileName;
    private long size = -1L;
    private int sizeThreshold;
    private boolean keepFormFieldInMemory;
    private File repository;
    private byte[] cachedContent;
    private File dfosFile;
    private FileItemHeaders headers;
    private String charset;
    private HttpServletRequest request;
    private FileUploadReName rename;
    private boolean saveInFile;

    public AbstractFileItem(String fieldName, String contentType, boolean isFormField, boolean saveInFile, String fileName, int sizeThreshold, boolean keepFormFieldInMemory, File repository, HttpServletRequest request, FileUploadReName fileUploadRename) {
        this(fieldName, contentType, isFormField, saveInFile, fileName, sizeThreshold, keepFormFieldInMemory, repository, request);
        this.rename = fileUploadRename;
        this.rename.setRepository(repository);
    }

    public AbstractFileItem(String fieldName, String contentType, boolean isFormField, boolean saveInFile, String fileName, int sizeThreshold, boolean keepFormFieldInMemory, File repository, HttpServletRequest request) {
        if (sizeThreshold < 0) {
            sizeThreshold = 0;
        }
        if (sizeThreshold == 0) {
            keepFormFieldInMemory = true;
        }
        if (repository == null) {
            repository = new File(System.getProperty("java.io.tmpdir"));
        }
        if (!repository.exists()) {
            repository.mkdirs();
        }
        this.fieldName = fieldName;
        this.contentType = contentType;
        this.isFormField = isFormField;
        this.fileName = fileName;
        this.sizeThreshold = sizeThreshold;
        this.saveInFile = saveInFile;
        this.keepFormFieldInMemory = keepFormFieldInMemory;
        this.repository = repository;
        this.request = request;
    }

    public File getRepository() {
        return this.repository;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.isInMemory()) {
            return new FileInputStream(this.dfos.getFile());
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.dfos.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getName() {
        return this.fileName;
    }

    public boolean isInMemory() {
        if (this.cachedContent != null) {
            return true;
        }
        return this.dfos.isInMemory();
    }

    public long getSize() {
        if (this.size >= 0L) {
            return this.size;
        }
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getData().length;
        }
        return this.dfos.getFile().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get() {
        if (this.isInMemory()) {
            if (this.cachedContent == null) {
                this.cachedContent = this.dfos.getData();
            }
            return this.cachedContent;
        }
        byte[] fileData = new byte[(int)this.getSize()];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.dfos.getFile());
            fis.read(fileData);
        }
        catch (IOException e) {
            fileData = null;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return fileData;
    }

    public String getString(String charset) throws UnsupportedEncodingException {
        return new String(this.get(), charset);
    }

    public String getString() {
        byte[] rawdata = this.get();
        String charset = null;
        if (this.isFormField()) {
            charset = this.getCharset();
        }
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        try {
            return new String(rawdata, charset);
        }
        catch (UnsupportedEncodingException e) {
            try {
                return new String(rawdata, DEFAULT_CHARSET);
            }
            catch (UnsupportedEncodingException ee) {
                return new String(rawdata);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws Exception {
        if (file != null) {
            file.getParentFile().mkdirs();
        }
        if (this.isInMemory()) {
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(file);
                fout.write(this.get());
            }
            finally {
                if (fout != null) {
                    fout.close();
                }
            }
        }
        File outputFile = this.getStoreLocation();
        if (outputFile != null) {
            this.size = outputFile.length();
            if (!outputFile.renameTo(file)) {
                BufferedInputStream in = null;
                FilterOutputStream out = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(outputFile));
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        } else {
            throw new FileUploadException("Cannot write uploaded file to disk!");
        }
    }

    public void delete() {
        this.cachedContent = null;
        File outputFile = this.getStoreLocation();
        if (outputFile != null && outputFile.exists()) {
            outputFile.delete();
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public void setFormField(boolean state) {
        this.isFormField = state;
    }

    public OutputStream getOutputStream() throws IOException {
        String serverFileName = this.fileName;
        if (this.rename != null) {
            serverFileName = this.rename.reName(this.fileName, this.request);
        }
        if (this.dfos == null) {
            int sizeThreshold;
            File outputFile = null;
            if (this.keepFormFieldInMemory && this.isFormField()) {
                sizeThreshold = Integer.MAX_VALUE;
            } else {
                sizeThreshold = this.saveInFile ? Integer.MIN_VALUE : this.sizeThreshold;
                outputFile = new File(serverFileName);
            }
            this.dfos = new DeferredFileOutputStream(sizeThreshold, outputFile);
        }
        return this.dfos;
    }

    public File getStoreLocation() {
        return this.dfos == null ? null : this.dfos.getFile();
    }

    public String toString() {
        return StringUtil.defaultIfEmpty((String)this.getName(), (String)this.getString());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.dfos.isInMemory()) {
            this.cachedContent = this.get();
        } else {
            this.cachedContent = null;
            this.dfosFile = this.dfos.getFile();
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        OutputStream output = this.getOutputStream();
        if (this.cachedContent != null) {
            output.write(this.cachedContent);
        } else {
            FileInputStream input = new FileInputStream(this.dfosFile);
            IOUtils.copy((InputStream)input, (OutputStream)output);
            this.dfosFile.delete();
            this.dfosFile = null;
        }
        output.close();
        this.cachedContent = null;
    }

    public FileItemHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(FileItemHeaders pHeaders) {
        this.headers = pHeaders;
    }
}

