/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.impl;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.weblayer.webcontext.parser.exception.UploadException;
import org.tinygroup.weblayer.webcontext.parser.fileupload.FileItemStorage;
import org.tinygroup.weblayer.webcontext.parser.fileupload.TinyFileItemFactory;
import org.tinygroup.weblayer.webcontext.parser.impl.DiskFileItemFactory;
import org.tinygroup.weblayer.webcontext.parser.impl.UploadServiceImpl;
import org.tinygroup.weblayer.webcontext.parser.upload.UploadParameters;

public class FileItemFactoryWrapper
implements FileItemFactory {
    private FileItemFactory itemFactory;

    public FileItemFactoryWrapper(UploadParameters parameters, UploadServiceImpl upload) {
        if (parameters.isDiskItemFactory()) {
            DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
            diskFileItemFactory.setRename(upload.getRename());
            diskFileItemFactory.setRepository(parameters.getRepository());
            diskFileItemFactory.setSizeThreshold((int)parameters.getSizeThreshold().getValue());
            diskFileItemFactory.setKeepFormFieldInMemory(parameters.isKeepFormFieldInMemory());
            diskFileItemFactory.setSaveInFile(parameters.isSaveInFile());
            diskFileItemFactory.setTemporary(parameters.isTemporary());
            this.itemFactory = diskFileItemFactory;
        } else {
            String stotageBeanName = parameters.getItemStorageBeanName();
            TinyFileItemFactory tinyFileItemFactory = new TinyFileItemFactory();
            if (!StringUtil.isBlank((String)stotageBeanName)) {
                FileItemStorage storage = (FileItemStorage)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(stotageBeanName);
                tinyFileItemFactory.setStorage(storage);
            }
            this.itemFactory = tinyFileItemFactory;
        }
    }

    public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
        if (this.itemFactory != null) {
            return this.itemFactory.createItem(fieldName, contentType, isFormField, fileName);
        }
        throw new UploadException("can not found fileItemFactory");
    }

    public FileItemFactory getFileItemFactory() {
        return this.itemFactory;
    }
}

