/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.impl;

import java.io.File;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.tinygroup.commons.tools.HumanReadableSize;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.support.BeanSupport;
import org.tinygroup.weblayer.webcontext.parser.exception.UploadException;
import org.tinygroup.weblayer.webcontext.parser.exception.UploadSizeLimitExceededException;
import org.tinygroup.weblayer.webcontext.parser.impl.FileItemFactoryWrapper;
import org.tinygroup.weblayer.webcontext.parser.impl.FileUploadRenameImpl;
import org.tinygroup.weblayer.webcontext.parser.impl.ServletFileUpload;
import org.tinygroup.weblayer.webcontext.parser.upload.FileUploadReName;
import org.tinygroup.weblayer.webcontext.parser.upload.UploadParameters;
import org.tinygroup.weblayer.webcontext.parser.upload.UploadService;

public class UploadServiceImpl
extends BeanSupport
implements UploadService {
    private static Logger logger = LoggerFactory.getLogger(UploadServiceImpl.class);
    private final UploadParameters params = new UploadParameters();
    private ServletFileUpload fileUpload;
    private FileUploadReName rename = new FileUploadRenameImpl();

    public FileUploadReName getRename() {
        return this.rename;
    }

    public void setRename(FileUploadReName rename) {
        this.rename = rename;
    }

    @Override
    public File getRepository() {
        return this.params.getRepository();
    }

    public void setRepository(File repository) {
        this.params.setRepository(repository);
    }

    @Override
    public HumanReadableSize getSizeMax() {
        return this.params.getSizeMax();
    }

    public void setSizeMax(HumanReadableSize sizeMax) {
        this.params.setSizeMax(sizeMax);
    }

    @Override
    public HumanReadableSize getFileSizeMax() {
        return this.params.getFileSizeMax();
    }

    public void setFileSizeMax(HumanReadableSize fileSizeMax) {
        this.params.setFileSizeMax(fileSizeMax);
    }

    @Override
    public HumanReadableSize getSizeThreshold() {
        return this.params.getSizeThreshold();
    }

    public void setSizeThreshold(HumanReadableSize sizeThreshold) {
        this.params.setSizeThreshold(sizeThreshold);
    }

    @Override
    public boolean isKeepFormFieldInMemory() {
        return this.params.isKeepFormFieldInMemory();
    }

    public void setKeepFormFieldInMemory(boolean keepFormFieldInMemory) {
        this.params.setKeepFormFieldInMemory(keepFormFieldInMemory);
    }

    @Override
    public boolean isSaveInFile() {
        return this.params.isSaveInFile();
    }

    public void setSaveInFile(boolean saveInFile) {
        this.params.setSaveInFile(saveInFile);
    }

    @Override
    public boolean isDiskItemFactory() {
        return this.params.isDiskItemFactory();
    }

    public void setDiskItemFactory(boolean isDiskItemFactory) {
        this.params.setDiskItemFactory(isDiskItemFactory);
    }

    @Override
    public String getItemStorageBeanName() {
        return this.params.getItemStorageBeanName();
    }

    public void setItemStorageBeanName(String itemStorageBeanName) {
        this.params.setItemStorageBeanName(itemStorageBeanName);
    }

    @Override
    public String[] getFileNameKey() {
        return this.params.getFileNameKey();
    }

    public void setFileNameKey(String[] fileNameKey) {
        this.params.setFileNameKey(fileNameKey);
    }

    @Override
    public boolean isTemporary() {
        return this.params.isTemporary();
    }

    public void setTemporary(boolean isTemporary) {
        this.params.setTemporary(isTemporary);
    }

    protected void init() {
        this.params.applyDefaultValues();
        logger.logMessage(LogLevel.INFO, "Upload Parameters: {}", new Object[]{this.params});
        this.fileUpload = this.getFileUpload(this.params, false);
    }

    @Override
    public boolean isMultipartContent(HttpServletRequest request) {
        return org.apache.commons.fileupload.servlet.ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    @Override
    public FileItem[] parseRequest(HttpServletRequest request) {
        return this.parseRequest(request, null);
    }

    @Override
    public FileItem[] parseRequest(HttpServletRequest request, UploadParameters params) {
        List<?> fileItems;
        this.assertInitialized();
        ServletFileUpload fileUpload = params == null || params.equals(this.params) ? this.fileUpload : this.getFileUpload(params, true);
        try {
            fileItems = fileUpload.parseRequest(request);
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            throw new UploadSizeLimitExceededException(e);
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            throw new UploadSizeLimitExceededException(e);
        }
        catch (FileUploadException e) {
            throw new UploadException(e);
        }
        return fileItems.toArray(new FileItem[fileItems.size()]);
    }

    private ServletFileUpload getFileUpload(UploadParameters params, boolean applyDefaultValues) {
        if (applyDefaultValues) {
            params.applyDefaultValues();
            logger.logMessage(LogLevel.DEBUG, "Upload Parameters: {}", new Object[]{params});
        }
        FileItemFactoryWrapper itemFactory = new FileItemFactoryWrapper(params, this);
        ServletFileUpload fileUpload = new ServletFileUpload(itemFactory);
        fileUpload.setSizeMax(params.getSizeMax().getValue());
        fileUpload.setFileSizeMax(params.getFileSizeMax().getValue());
        fileUpload.setFileNameKey(params.getFileNameKey());
        return fileUpload;
    }
}

