/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.valueparser.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.StringEscapeUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.impl.AbstractFileObject;
import org.tinygroup.weblayer.webcontext.parser.ParserWebContext;
import org.tinygroup.weblayer.webcontext.parser.exception.UploadException;
import org.tinygroup.weblayer.webcontext.parser.exception.UploadSizeLimitExceededException;
import org.tinygroup.weblayer.webcontext.parser.fileupload.TinyFileItem;
import org.tinygroup.weblayer.webcontext.parser.fileupload.TinyItemFileObject;
import org.tinygroup.weblayer.webcontext.parser.impl.DiskFileItem;
import org.tinygroup.weblayer.webcontext.parser.impl.FileObjectInDisk;
import org.tinygroup.weblayer.webcontext.parser.impl.FileObjectInMemory;
import org.tinygroup.weblayer.webcontext.parser.impl.InMemoryFormFieldItem;
import org.tinygroup.weblayer.webcontext.parser.impl.ItemFileObject;
import org.tinygroup.weblayer.webcontext.parser.upload.ParamValueFilter;
import org.tinygroup.weblayer.webcontext.parser.upload.ParameterParserFilter;
import org.tinygroup.weblayer.webcontext.parser.upload.ParameterValueFilter;
import org.tinygroup.weblayer.webcontext.parser.upload.UploadParameters;
import org.tinygroup.weblayer.webcontext.parser.upload.UploadService;
import org.tinygroup.weblayer.webcontext.parser.upload.UploadedFileFilter;
import org.tinygroup.weblayer.webcontext.parser.valueparser.AbstractValueParser;
import org.tinygroup.weblayer.webcontext.parser.valueparser.ParameterParser;
import org.tinygroup.weblayer.webcontext.parser.valueparser.ValueList;
import org.tinygroup.weblayer.webcontext.util.QueryStringParser;

public class ParameterParserImpl
extends AbstractValueParser
implements ParameterParser {
    private final UploadService upload;
    private final boolean trimming;
    private final ParameterParserFilter[] filters;
    private final String htmlFieldSuffix;
    private boolean uploadProcessed;
    private List<FileItem> fileItems = new ArrayList<FileItem>();

    public ParameterParserImpl(ParserWebContext webContext, UploadService upload, boolean trimming, ParameterParserFilter[] filters, String htmlFieldSuffix) {
        super(webContext);
        this.upload = upload;
        this.trimming = trimming;
        this.filters = filters;
        this.htmlFieldSuffix = htmlFieldSuffix;
        HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)webContext.getRequest();
        HttpServletRequest wrappedRequest = (HttpServletRequest)wrapper.getRequest();
        boolean isMultipart = false;
        if (webContext.isAutoUpload() && upload != null && (isMultipart = upload.isMultipartContent(wrappedRequest))) {
            try {
                this.parseUpload();
            }
            catch (UploadSizeLimitExceededException e) {
                this.add("upload_failed", Boolean.TRUE);
                this.add("upload_size_limit_exceeded", Boolean.TRUE);
                logger.errorMessage("File upload exceeds the size limit", (Throwable)e, new Object[0]);
                throw e;
            }
            catch (UploadException e) {
                this.add("upload_failed", Boolean.TRUE);
                logger.errorMessage("Upload failed", (Throwable)e, new Object[0]);
                throw e;
            }
        }
        if (!isMultipart) {
            String method = wrappedRequest.getMethod();
            if (webContext.isUseServletEngineParser() || "post".equalsIgnoreCase(method) || "put".equalsIgnoreCase(method)) {
                this.parseByServletEngine(wrappedRequest);
            } else {
                this.parseQueryString(webContext, wrappedRequest);
            }
            this.postProcessParams();
        }
    }

    private void parseByServletEngine(HttpServletRequest wrappedRequest) {
        Map parameters = wrappedRequest.getParameterMap();
        if (parameters != null && parameters.size() > 0) {
            for (Map.Entry entry : parameters.entrySet()) {
                String[] values;
                String key = (String)entry.getKey();
                for (String value : values = (String[])entry.getValue()) {
                    this.add(key, value);
                }
            }
        }
    }

    private void parseQueryString(ParserWebContext requestContext, HttpServletRequest wrappedRequest) {
        String charset = requestContext.isUseBodyEncodingForURI() ? wrappedRequest.getCharacterEncoding() : requestContext.getURIEncoding();
        QueryStringParser parser = new QueryStringParser(charset, "ISO-8859-1"){

            @Override
            protected void add(String key, String value) {
                ParameterParserImpl.this.add(key, value);
            }
        };
        parser.parse(wrappedRequest.getQueryString());
    }

    private void postProcessParams() {
        HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)this.webContext.getRequest();
        HttpServletRequest wrappedRequest = (HttpServletRequest)wrapper.getRequest();
        boolean[] filtering = null;
        if (!ArrayUtil.isEmptyArray((Object)this.filters)) {
            filtering = new boolean[this.filters.length];
            for (int i = 0; i < this.filters.length; ++i) {
                filtering[i] = this.filters[i].isFiltering(wrappedRequest);
            }
        }
        String[] keys = this.getKeys();
        LinkedList keysToRemove = CollectionUtil.createLinkedList();
        for (String key : keys) {
            if (key.endsWith(this.htmlFieldSuffix)) {
                keysToRemove.add(key);
                key = key.substring(0, key.length() - this.htmlFieldSuffix.length());
                if (this.containsKey(key)) continue;
                this.setObjects(key, this.processValues(key, true, filtering));
                continue;
            }
            boolean isHtml = !StringUtil.isBlank((String)this.getString(key + this.htmlFieldSuffix));
            this.setObjects(key, this.processValues(key, isHtml, filtering));
        }
        for (String key : keysToRemove) {
            this.remove(key);
        }
    }

    private Object[] processValues(String key, boolean isHtmlField, boolean[] filtering) {
        Object[] values = this.getObjects(key);
        ArrayList<Object> paramValues = new ArrayList<Object>();
        for (int i = 0; i < values.length; ++i) {
            FileItem fileItem;
            Object value = values[i];
            if (value instanceof ItemFileObject && (fileItem = ((ItemFileObject)value).getFileItem()).isFormField()) {
                value = fileItem.toString();
            }
            if (value instanceof String) {
                this.stringValueFilter(key, isHtmlField, filtering, value, paramValues);
                continue;
            }
            if (!(value instanceof ItemFileObject)) continue;
            this.fileItemFilter(key, filtering, value, paramValues);
        }
        if (paramValues.size() > 0) {
            if (paramValues.size() == 1) {
                this.webContext.put(key, paramValues.get(0));
            } else {
                this.webContext.put(key, paramValues.toArray());
            }
        }
        return paramValues.toArray();
    }

    private void fileItemFilter(String key, boolean[] filtering, Object value, List<Object> paramValues) {
        FileItem fileItem;
        FileItem processFileItem = fileItem = ((ItemFileObject)value).getFileItem();
        if (filtering != null) {
            for (int j = 0; j < this.filters.length; ++j) {
                ParameterParserFilter filter = this.filters[j];
                if (!(filter instanceof UploadedFileFilter) || !filtering[j]) continue;
                processFileItem = ((UploadedFileFilter)filter).filter(key, processFileItem);
            }
        }
        if (processFileItem == null) {
            this.remove(key, value);
            this.fileItems.remove(fileItem);
            fileItem.delete();
        } else {
            fileItem = processFileItem;
            if (!fileItem.isFormField() && fileItem.getContentType() != null) {
                paramValues.add(value);
            }
        }
    }

    private void stringValueFilter(String key, boolean isHtmlField, boolean[] filtering, Object value, List<Object> paramValues) {
        Object processValue = value;
        if (!isHtmlField && this.webContext.isUnescapeParameters()) {
            processValue = StringEscapeUtil.unescapeEntities(null, (String)((String)value));
        }
        if (filtering != null) {
            for (int j = 0; j < this.filters.length; ++j) {
                ParameterParserFilter filter = this.filters[j];
                if (filter instanceof ParameterValueFilter && filtering[j]) {
                    processValue = ((ParameterValueFilter)filter).filter(key, (String)processValue, isHtmlField);
                }
                if (!(filter instanceof ParamValueFilter) || !filtering[j] || !((ParamValueFilter)filter).isFilter(key)) continue;
                processValue = ((ParamValueFilter)filter).valueFilter((String)processValue, this.webContext);
            }
        }
        paramValues.add(processValue);
    }

    @Override
    public FileObject getFileObject(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? null : container.getFileObject();
    }

    @Override
    public FileObject[] getFileObjects(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? new FileObject[]{} : container.getFileObjects();
    }

    @Override
    public void add(String key, FileItem value) {
        if (value.isFormField()) {
            this.add(key, value.getString());
        } else if (!StringUtil.isEmpty((String)value.getName()) || value.getSize() > 0L) {
            this.add(key, (Object)value);
        }
    }

    @Override
    public void add(String key, Object value) {
        if (value == null) {
            value = "";
        }
        if (this.trimming && value instanceof String) {
            value = StringUtil.trimToEmpty((String)((String)value));
        }
        this.getValueList(key, true).addValue(value);
    }

    @Override
    public void parseUpload() throws UploadException {
        this.parseUpload(null);
    }

    @Override
    public void parseUpload(UploadParameters params) throws UploadException {
        FileItem[] items;
        if (this.uploadProcessed || this.upload == null) {
            return;
        }
        for (FileItem item : items = this.upload.parseRequest(this.webContext.getRequest(), params)) {
            AbstractFileObject fileObject = null;
            if (item instanceof InMemoryFormFieldItem) {
                fileObject = new FileObjectInMemory((InMemoryFormFieldItem)item);
            } else if (item instanceof DiskFileItem) {
                fileObject = new FileObjectInDisk((DiskFileItem)item);
            } else if (item instanceof TinyFileItem) {
                TinyFileItem tinyFileItem = (TinyFileItem)item;
                fileObject = tinyFileItem.isInMemory() ? new TinyItemFileObject(tinyFileItem) : tinyFileItem.getFileObject();
            }
            this.add(item.getFieldName(), fileObject);
            this.fileItems.add(item);
        }
        this.uploadProcessed = true;
        this.postProcessParams();
    }

    @Override
    protected String getCharacterEncoding() {
        String charset = this.webContext.getRequest().getCharacterEncoding();
        return charset == null ? "ISO-8859-1" : charset;
    }

    @Override
    public String toQueryString() {
        QueryStringParser parser = new QueryStringParser();
        for (String element : this.keySet()) {
            String key = element;
            Object[] values = this.getObjects(key);
            if (ArrayUtil.isEmptyArray((Object)values)) continue;
            for (Object valueObject : values) {
                if (valueObject != null && !(valueObject instanceof String)) continue;
                parser.append(key, (String)valueObject);
            }
        }
        return parser.toQueryString();
    }

    @Override
    public FileItem[] getFileItems() {
        if (this.fileItems.isEmpty()) {
            return new FileItem[0];
        }
        return this.fileItems.toArray(new FileItem[0]);
    }
}

