/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.valueparser.impl;

import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.CollectionFactory;
import org.springframework.core.MethodParameter;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.BasicConstant;
import org.tinygroup.commons.tools.ClassUtil;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.commons.tools.ToStringBuilder;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.webcontext.parser.valueparser.ValueList;

public class ValueListSupport
implements ValueList {
    private final TypeConverter converter;
    private final List<Object> values = CollectionUtil.createLinkedList();
    private final boolean quiet;

    public ValueListSupport(TypeConverter converter, boolean quiet) {
        this.converter = (TypeConverter)Assert.assertNotNull((Object)converter, (String)"converter", (Object[])new Object[0]);
        this.quiet = quiet;
    }

    @Override
    public boolean getBooleanValue() {
        return this.getBooleanValue(null);
    }

    @Override
    public boolean getBooleanValue(Boolean defaultValue) {
        return this.getValueOfType(Boolean.class, true, null, new Object[]{defaultValue});
    }

    @Override
    public byte getByteValue() {
        return this.getByteValue(null);
    }

    @Override
    public byte getByteValue(Byte defaultValue) {
        return this.getValueOfType(Byte.class, true, null, new Object[]{defaultValue});
    }

    @Override
    public byte[] getBytes(String charset) throws UnsupportedEncodingException {
        String value = this.getStringValue();
        return value == null ? BasicConstant.EMPTY_BYTE_ARRAY : value.getBytes(charset);
    }

    @Override
    public char getCharacterValue() {
        return this.getCharacterValue(null);
    }

    @Override
    public char getCharacterValue(Character defaultValue) {
        return this.getValueOfType(Character.class, true, null, new Object[]{defaultValue}).charValue();
    }

    @Override
    public double getDoubleValue() {
        return this.getDoubleValue(null);
    }

    @Override
    public double getDoubleValue(Double defaultValue) {
        return this.getValueOfType(Double.class, true, null, new Object[]{defaultValue});
    }

    @Override
    public float getFloatValue() {
        return this.getFloatValue(null);
    }

    @Override
    public float getFloatValue(Float defaultValue) {
        return this.getValueOfType(Float.class, true, null, new Object[]{defaultValue}).floatValue();
    }

    @Override
    public int getIntegerValue() {
        return this.getIntegerValue(null);
    }

    @Override
    public int getIntegerValue(Integer defaultValue) {
        return this.getValueOfType(Integer.class, true, null, new Object[]{defaultValue});
    }

    @Override
    public int[] getIntegerValues() {
        return this.getIntegerValues(BasicConstant.EMPTY_INT_ARRAY);
    }

    @Override
    public int[] getIntegerValues(int[] defaultValue) {
        return this.getValueOfType(int[].class, null, this.toIntegerArray(defaultValue));
    }

    @Override
    public long getLongValue() {
        return this.getLongValue(null);
    }

    @Override
    public long getLongValue(Long defaultValue) {
        return this.getValueOfType(Long.class, true, null, new Object[]{defaultValue});
    }

    @Override
    public long[] getLongValues() {
        return this.getLongValues(BasicConstant.EMPTY_LONG_ARRAY);
    }

    @Override
    public long[] getLongValues(long[] defaultValue) {
        return this.getValueOfType(long[].class, null, this.toLongArray(defaultValue));
    }

    @Override
    public short getShortValue() {
        return this.getShortValue(null);
    }

    @Override
    public short getShortValue(Short defaultValue) {
        return this.getValueOfType(Short.class, true, null, new Object[]{defaultValue});
    }

    @Override
    public Date getDateValue(DateFormat format) {
        return this.getDateValue(format, null);
    }

    @Override
    public Date getDateValue(DateFormat format, Date defaultValue) {
        String value = this.getStringValue();
        Date date = defaultValue;
        if (value != null) {
            try {
                format.setLenient(false);
                date = format.parse(value);
            }
            catch (ParseException e) {
                date = defaultValue;
            }
        }
        return date;
    }

    @Override
    public String getStringValue() {
        return this.getStringValue(null);
    }

    @Override
    public String getStringValue(String defaultValue) {
        String value = this.getValueOfType(String.class, null, new Object[]{defaultValue});
        if (value == null || "null".equals(value) || value.length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public String[] getStringValues() {
        return this.getStringValues(BasicConstant.EMPTY_STRING_ARRAY);
    }

    @Override
    public String[] getStringValues(String[] defaultValue) {
        String[] values = this.getValueOfType(String[].class, null, defaultValue);
        if (values == null) {
            values = defaultValue;
        } else {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null && !"null".equals(values[i]) && values[i].length() != 0) continue;
                values[i] = "";
            }
        }
        return values;
    }

    @Override
    public FileObject getFileObject() {
        Object value = this.getValue();
        return value instanceof FileObject ? (FileObject)value : null;
    }

    @Override
    public FileObject[] getFileObjects() {
        LinkedList items = CollectionUtil.createLinkedList();
        for (Object value : this.values) {
            if (!(value instanceof FileObject)) continue;
            items.add((FileObject)value);
        }
        return items.toArray(new FileObject[items.size()]);
    }

    @Override
    public Object getValue() {
        return this.getValue(null);
    }

    @Override
    public void setValue(Object value) {
        this.clear();
        this.addValue(value);
    }

    @Override
    public Object getValue(Object defaultValue) {
        Object value = null;
        if (this.values.size() > 0) {
            value = this.values.get(0);
        }
        return ObjectUtil.defaultIfNull(value, (Object)defaultValue);
    }

    @Override
    public Object[] getValues() {
        return this.getValues(BasicConstant.EMPTY_OBJECT_ARRAY);
    }

    @Override
    public void setValues(Object[] values) {
        this.clear();
        if (!ArrayUtil.isEmptyArray((Object)values)) {
            for (Object value : values) {
                this.addValue(value);
            }
        }
    }

    @Override
    public Object[] getValues(Object[] defaultValues) {
        Object[] values = this.values.toArray();
        return ArrayUtil.isEmptyArray((Object)values) ? defaultValues : values;
    }

    @Override
    public <T> T getValueOfType(Class<T> type, MethodParameter methodParameter, Object[] defaultValues) {
        return this.getValueOfType(type, false, methodParameter, defaultValues);
    }

    @Override
    public <T> T getValueOfType(Class<T> type, boolean isPrimitive, MethodParameter methodParameter, Object[] defaultValues) {
        Object[] values;
        Object defaultValue;
        if (defaultValues == null || defaultValues.length == 1 && defaultValues[0] == null) {
            defaultValues = BasicConstant.EMPTY_OBJECT_ARRAY;
        }
        if (type.isPrimitive()) {
            isPrimitive = true;
            type = ClassUtil.getWrapperTypeIfPrimitive(type);
        }
        if (isPrimitive && ArrayUtil.isEmptyArray((Object)defaultValues) && (defaultValue = ClassUtil.getPrimitiveDefaultValue((Class)type)) != null) {
            defaultValues = new Object[]{defaultValue};
        }
        if ((values = this.getValues(defaultValues)).length == 1 && ObjectUtil.isEmptyObject((Object)values[0])) {
            values = defaultValues;
        }
        try {
            return this.convert(type, methodParameter, values, defaultValues.length > 0 ? defaultValues[0] : null);
        }
        catch (TypeMismatchException e) {
            if (this.quiet) {
                return this.convert(type, methodParameter, defaultValues, null);
            }
            throw e;
        }
    }

    private <T> T convert(Class<T> type, MethodParameter methodParameter, Object[] values, Object defaultValue) {
        boolean requiresArray;
        if (values == null) {
            values = BasicConstant.EMPTY_STRING_ARRAY;
        }
        Object convertedValue = null;
        boolean bl = requiresArray = type.isArray() || CollectionFactory.isApproximableCollectionType(type);
        if (values.length == 0) {
            if (!type.equals(String.class)) {
                try {
                    convertedValue = this.converter.convertIfNecessary((Object)values, type, methodParameter);
                }
                catch (TypeMismatchException typeMismatchException) {}
            }
        } else if (requiresArray) {
            convertedValue = this.converter.convertIfNecessary((Object)values, type, methodParameter);
        } else {
            Object singleValue = values[0];
            if (ObjectUtil.isEmptyObject((Object)singleValue)) {
                singleValue = defaultValue;
            }
            convertedValue = this.converter.convertIfNecessary(singleValue, type, methodParameter);
        }
        return type.cast(convertedValue);
    }

    private Integer[] toIntegerArray(int[] values) {
        if (ArrayUtil.isEmptyArray((Object)values)) {
            return BasicConstant.EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] integerValues = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            integerValues[i] = values[i];
        }
        return integerValues;
    }

    private Long[] toLongArray(long[] values) {
        if (ArrayUtil.isEmptyArray((Object)values)) {
            return BasicConstant.EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] longValues = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            longValues[i] = values[i];
        }
        return longValues;
    }

    @Override
    public void addValue(boolean value) {
        this.addValue(Boolean.toString(value));
    }

    @Override
    public void addValue(byte value) {
        this.addValue(Byte.toString(value));
    }

    @Override
    public void addValue(char value) {
        this.addValue(Character.toString(value));
    }

    @Override
    public void addValue(double value) {
        this.addValue(Double.toString(value));
    }

    @Override
    public void addValue(float value) {
        this.addValue(Float.toString(value));
    }

    @Override
    public void addValue(int value) {
        this.addValue(Integer.toString(value));
    }

    @Override
    public void addValue(long value) {
        this.addValue(Long.toString(value));
    }

    @Override
    public void addValue(short value) {
        this.addValue(Short.toString(value));
    }

    @Override
    public void addValue(Object value) {
        this.values.add(value);
    }

    @Override
    public void removeValue(Object value) {
        this.values.remove(value);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    protected void clear() {
        this.values.clear();
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder();
        if (this.values.size() == 1) {
            buf.append(this.values.get(0));
        } else {
            buf.appendCollection(this.values);
        }
        return buf.toString();
    }
}

