/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.rewrite;

import java.util.regex.MatchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.BasicConstant;
import org.tinygroup.commons.tools.MatchResultSubstitution;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.commons.tools.StringEscapeUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.commons.tools.ToStringBuilder;
import org.tinygroup.weblayer.webcontext.parser.valueparser.ParameterParser;
import org.tinygroup.weblayer.webcontext.rewrite.Flags;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteUtil;

public class RewriteSubstitution
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RewriteSubstitution.class);
    private static final String SPLIT_CHAR = ",";
    private String uri;
    private String flags;
    private SubstitutionFlags subflags;
    private Parameter[] parameters;

    public void setUri(String uri) {
        this.uri = StringUtil.trimToNull((String)uri);
    }

    public SubstitutionFlags getSubFlags() {
        return this.subflags;
    }

    public String getFlags() {
        return this.flags;
    }

    public void setFlags(String flags) {
        this.flags = flags;
        String[] flagArray = null;
        flagArray = StringUtil.isEmpty((String)flags) ? BasicConstant.EMPTY_STRING_ARRAY : flags.split(SPLIT_CHAR);
        this.subflags = new SubstitutionFlags(flagArray);
    }

    public void setParameters(Parameter[] params) {
        this.parameters = params;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.subflags == null) {
            this.subflags = new SubstitutionFlags();
        }
        if (this.parameters == null) {
            this.parameters = new Parameter[0];
        }
    }

    public String substitute(String path, MatchResultSubstitution resultSubs) {
        if (this.uri == null) {
            if (log.isTraceEnabled()) {
                log.trace("No substitution applied to path: \"{}\"", (Object)StringEscapeUtil.escapeJava((String)path));
            }
            return path;
        }
        String subsPath = resultSubs.substitute(this.uri);
        if (!RewriteUtil.isFullURL(subsPath)) {
            MatchResult ruleMatchResult = resultSubs.getMatch();
            subsPath = path.substring(0, ruleMatchResult.start()) + subsPath + path.substring(ruleMatchResult.end());
        }
        if (log.isDebugEnabled()) {
            log.debug("Rewriting \"{}\" to \"{}\"", (Object)StringEscapeUtil.escapeJava((String)path), (Object)StringEscapeUtil.escapeJava((String)subsPath));
        }
        return subsPath;
    }

    public boolean substituteParameters(ParameterParser params, MatchResultSubstitution resultSubs) {
        boolean parameterSubstituted = false;
        if (!params.isEmpty() && !this.subflags.hasQSA()) {
            params.clear();
            parameterSubstituted = true;
            log.debug("All parameters have been cleared.  To prevent from clearing the parameters, just specify \"QSA\" or \"qsappend\"(query string append) flag to the substitution");
        }
        for (Parameter param : this.parameters) {
            String key = param.getKey(resultSubs);
            String[] values = param.getValues(resultSubs);
            if (StringUtil.isEmpty((String)key)) continue;
            if (ArrayUtil.isEmptyArray((Object)values) || values.length == 1 && StringUtil.isEmpty((String)values[0])) {
                params.remove(key);
                if (log.isDebugEnabled()) {
                    log.debug("Removed parameter: \"{}\"", (Object)StringEscapeUtil.escapeJava((String)key));
                }
            } else {
                params.setStrings(key, values);
                if (log.isDebugEnabled()) {
                    log.debug("Set parameter: \"{}\"=\"{}\"", (Object)StringEscapeUtil.escapeJava((String)key), (Object)ObjectUtil.toString((Object)values));
                }
            }
            parameterSubstituted = true;
        }
        return parameterSubstituted;
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        if (this.uri != null) {
            mb.append("uri", (Object)this.uri);
        }
        if (!ArrayUtil.isEmptyArray((Object)this.parameters)) {
            mb.append("params", (Object)this.parameters);
        }
        if (!this.subflags.isEmpty()) {
            mb.append("flags", (Object)this.subflags);
        }
        return new ToStringBuilder().append((Object)"Substitution").append((Object)mb).toString();
    }

    public static class Parameter
    implements InitializingBean {
        private String key;
        private String[] values;

        public void setKey(String key) {
            this.key = StringUtil.trimToNull((String)key);
        }

        public void setValue(String value) {
            this.values = value.split(RewriteSubstitution.SPLIT_CHAR);
        }

        public void setValues(String[] values) {
            this.values = values;
        }

        public void afterPropertiesSet() throws Exception {
            Assert.assertNotNull((Object)this.key, (String)"missing key attribute for parameter", (Object[])new Object[0]);
            if (this.values == null) {
                this.values = BasicConstant.EMPTY_STRING_ARRAY;
            }
        }

        public String getKey(MatchResultSubstitution resultSubs) {
            return resultSubs.substitute(this.key);
        }

        public String[] getValues(MatchResultSubstitution resultSubs) {
            String[] subsValues = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                subsValues[i] = resultSubs.substitute(this.values[i]);
            }
            return subsValues;
        }

        public String toString() {
            ToStringBuilder buf = new ToStringBuilder().append((Object)this.key).append((Object)" = ");
            if (this.values.length == 1) {
                buf.append((Object)this.values[0]);
            } else {
                buf.appendArray((Object[])this.values);
            }
            return buf.toString();
        }
    }

    public static class SubstitutionFlags
    extends Flags {
        public SubstitutionFlags() {
        }

        public SubstitutionFlags(String ... flags) {
            super(flags);
        }

        public boolean hasQSA() {
            return this.hasFlags("QSA", "qsappend");
        }

        public boolean hasC() {
            return this.hasFlags("C", "chain");
        }

        public boolean hasL() {
            return this.hasFlags("L", "last");
        }

        public int getRedirectCode() {
            String value = this.getFlagValue("R", "redirect");
            int defaultStatusCode = 302;
            if (value == null) {
                return 0;
            }
            if (value.length() == 0) {
                return defaultStatusCode;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return defaultStatusCode;
            }
        }
    }
}

