/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.encrypter.impl;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.weblayer.webcontext.session.encrypter.AbstractJceEncrypter;

public class AesEncrypter
extends AbstractJceEncrypter {
    public static final String ALG_NAME = "AES";
    public static final int DEFAULT_KEY_SIZE = 128;
    private String key;
    private int keySize;
    private SecretKeySpec keySpec;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = StringUtil.trimToNull((String)key);
    }

    public int getKeySize() {
        return this.keySize <= 0 ? 128 : this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    protected void init() throws Exception {
        Assert.assertNotNull((Object)this.key, (String)"no key", (Object[])new Object[0]);
        byte[] raw = this.key.getBytes("UTF-8");
        int keySize = this.getKeySize();
        int actualKeySize = raw.length * 8;
        Assert.assertTrue((keySize == actualKeySize ? 1 : 0) != 0, (String)"Illegal key: expected size=%d, actual size is %d", (Object[])new Object[]{keySize, actualKeySize});
        this.keySpec = new SecretKeySpec(raw, ALG_NAME);
    }

    @Override
    protected Cipher createCipher(int mode) throws Exception {
        Cipher cipher = Cipher.getInstance(ALG_NAME);
        cipher.init(mode, this.keySpec);
        return cipher;
    }

    public String toString() {
        return "AES(keySize=" + this.getKeySize() + ")";
    }
}

