/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.impl;

import org.tinygroup.commons.tools.ToStringBuilder;
import org.tinygroup.weblayer.webcontext.session.SessionStore;
import org.tinygroup.weblayer.webcontext.session.impl.SessionImpl;

public class SessionAttribute {
    private String storeName;
    private SessionStore store;
    private SessionStore.StoreContext storeContext;
    private SessionImpl session;
    private String name;
    private Object value;
    private boolean loaded;
    private boolean modified;

    public SessionAttribute(String name, SessionImpl session, String storeName, SessionStore.StoreContext storeContext) {
        this.name = name;
        this.session = session;
        this.storeName = storeName;
        this.store = session.getSessionWebContext().getSessionConfig().getStores().getStore(storeName);
        this.storeContext = storeContext;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        if (!this.loaded && !this.modified) {
            this.value = this.store.loadAttribute(this.getName(), this.session.getId(), this.storeContext);
            this.loaded = true;
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        this.modified = true;
    }

    void updateValue(Object value) {
        this.value = value;
    }

    public boolean isModified() {
        return this.modified;
    }

    void setModified(boolean modified) {
        this.modified = modified;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public SessionStore getStore() {
        return this.store;
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("name", (Object)this.name);
        mb.append("value", this.value);
        mb.append("storeName", (Object)this.storeName);
        mb.append("loaded", (Object)this.loaded);
        mb.append("modified", (Object)this.modified);
        return new ToStringBuilder().append((Object)"SessionAttribute").append((Object)mb).toString();
    }
}

