/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.commons.tools.ToStringBuilder;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.configmanager.TinyListenerConfigManager;
import org.tinygroup.weblayer.configmanager.TinyListenerConfigManagerHolder;
import org.tinygroup.weblayer.webcontext.session.HttpHeaderSessionStore;
import org.tinygroup.weblayer.webcontext.session.Session;
import org.tinygroup.weblayer.webcontext.session.SessionAttributeInterceptor;
import org.tinygroup.weblayer.webcontext.session.SessionConfig;
import org.tinygroup.weblayer.webcontext.session.SessionInterceptor;
import org.tinygroup.weblayer.webcontext.session.SessionLifecycleListener;
import org.tinygroup.weblayer.webcontext.session.SessionManager;
import org.tinygroup.weblayer.webcontext.session.SessionModel;
import org.tinygroup.weblayer.webcontext.session.SessionModelEncoder;
import org.tinygroup.weblayer.webcontext.session.SessionStore;
import org.tinygroup.weblayer.webcontext.session.SessionWebContext;
import org.tinygroup.weblayer.webcontext.session.impl.SessionAttribute;
import org.tinygroup.weblayer.webcontext.session.impl.SessionModelImpl;
import org.tinygroup.weblayer.webcontext.session.model.SessionManagerFactory;

public class SessionImpl
implements HttpSession,
Serializable,
Session {
    private static final Logger log = LoggerFactory.getLogger(SessionImpl.class);
    private final transient HttpSessionInternal sessionInternal = new HttpSessionInternal();
    private String sessionID;
    private transient SessionWebContext webContext;
    private String modelKey;
    private SessionModelImpl model;
    private boolean isNew;
    private transient Map<String, SessionAttribute> attrs = CollectionUtil.createHashMap();
    private transient Map<String, Object> storeStates = CollectionUtil.createHashMap();
    private boolean invalidated = false;
    private boolean cleared = false;
    private transient Set<String> clearingStores = CollectionUtil.createHashSet();

    public SessionImpl(String sessionID, SessionWebContext webContext, boolean isNew, boolean create) {
        EventType event;
        this.sessionID = (String)Assert.assertNotNull((Object)sessionID, (String)"no sessionID", (Object[])new Object[0]);
        this.webContext = webContext;
        this.modelKey = webContext.getSessionConfig().getModelKey();
        if (isNew) {
            event = EventType.CREATED;
            log.logMessage(LogLevel.DEBUG, "No session ID was found in cookie or URL.  A new session will be created.");
            this.sessionInternal.invalidate();
        } else {
            this.model = (SessionModelImpl)this.sessionInternal.getAttribute(this.modelKey);
            if (this.model == null) {
                event = EventType.CREATED;
                log.logMessage(LogLevel.DEBUG, "Session state was not found for sessionID \"{0}\".  A new session will be created.", new Object[]{sessionID});
                isNew = true;
                this.sessionInternal.invalidate();
            } else {
                boolean expired = false;
                String modelSessionID = StringUtil.trimToNull((String)this.model.getSessionID());
                if (modelSessionID != null && !modelSessionID.equals(sessionID)) {
                    expired = true;
                    log.logMessage(LogLevel.WARN, "Requested session ID \"{0}\" does not match the ID in session model \"{1}\".  Force expired the session.", new Object[]{sessionID, modelSessionID});
                }
                this.model.setSession(this);
                if (expired |= this.model.isExpired()) {
                    event = EventType.RECREATED;
                    log.logMessage(LogLevel.DEBUG, "Session has expired: sessionID={}, created at {}, last accessed at {}, maxInactiveInterval={}, forceExpirationPeriod={}", new Object[]{modelSessionID, new Date(this.model.getCreationTime()), new Date(this.model.getLastAccessedTime()), this.model.getMaxInactiveInterval(), this.getSessionWebContext().getSessionConfig().getForceExpirationPeriod()});
                    isNew = true;
                    this.sessionInternal.invalidate();
                } else {
                    event = EventType.VISITED;
                    log.logMessage(LogLevel.TRACE, "Activate session: sessionID={}, last accessed at {}, maxInactiveInterval={}", new Object[]{modelSessionID, new Date(this.model.getLastAccessedTime()), this.model.getMaxInactiveInterval()});
                    this.model.touch();
                }
            }
        }
        this.isNew = isNew;
        this.sessionInternal.setAttribute(this.modelKey, this.model);
        this.fireEvent(event);
        this.sessionActivated();
    }

    public SessionWebContext getSessionWebContext() {
        return this.webContext;
    }

    public SessionModel getSessionModel() {
        return this.model;
    }

    public String getId() {
        return this.sessionID;
    }

    @Override
    public long getCreationTime() {
        this.assertValid("getCreationTime");
        return this.sessionInternal.getCreationTime();
    }

    @Override
    public long getLastAccessedTime() {
        this.assertValid("getLastAccessedTime");
        return this.model.getLastAccessedTime();
    }

    @Override
    public int getMaxInactiveInterval() {
        this.assertModel("getMaxInactiveInterval");
        return this.model.getMaxInactiveInterval();
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.assertModel("setMaxInactiveInterval");
        this.model.setMaxInactiveInterval(maxInactiveInterval);
    }

    @Override
    public String getSessionID() {
        this.assertModel("getSessionID");
        return this.model.getSessionID();
    }

    @Override
    public boolean isExpired() {
        this.assertModel("isExpired");
        return this.model.isExpired();
    }

    public ServletContext getServletContext() {
        return this.webContext.getServletContext();
    }

    public Object getAttribute(String name) {
        this.assertValid("getAttribute");
        return this.sessionInternal.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.assertValid("getAttributeNames");
        Set<String> attrNames = this.getAttributeNameSet();
        final Iterator<String> i = attrNames.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return i.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)i.next();
            }
        };
    }

    private Set<String> getAttributeNameSet() {
        SessionConfig sessionConfig = this.webContext.getSessionConfig();
        String[] storeNames = sessionConfig.getStores().getStoreNames();
        LinkedHashSet attrNames = CollectionUtil.createLinkedHashSet();
        for (String storeName : storeNames) {
            SessionStore store = sessionConfig.getStores().getStore(storeName);
            for (String attrName : store.getAttributeNames(this.getId(), new StoreContextImpl(storeName))) {
                if (ObjectUtil.isEquals((Object)attrName, (Object)this.modelKey)) continue;
                attrNames.add(attrName);
            }
        }
        for (SessionAttribute attr : this.attrs.values()) {
            if (attr.getValue() == null) {
                attrNames.remove(attr.getName());
                continue;
            }
            attrNames.add(attr.getName());
        }
        attrNames.remove(this.modelKey);
        return attrNames;
    }

    public void setAttribute(String name, Object value) {
        this.assertValid("setAttribute");
        this.assertAttributeNameForModification("setAttribute", name);
        Object oldValue = this.getAttribute(name);
        this.sessionInternal.setAttribute(name, value);
        this.setAttributeListener(name, value, oldValue);
        this.valueBoundListener(name, value);
    }

    private void valueBoundListener(String name, Object value) {
        TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
        List<HttpSessionBindingListener> listeners = configManager.getSessionBindingListeners();
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, value);
        if (value instanceof HttpSessionBindingListener) {
            for (HttpSessionBindingListener listener : listeners) {
                log.logMessage(LogLevel.DEBUG, "HttpSessionBindingListener:[{0}] will be valueBound", new Object[]{listener});
                listener.valueBound(event);
                log.logMessage(LogLevel.DEBUG, "HttpSessionBindingListener:[{0}] valueBound", new Object[]{listener});
            }
        }
    }

    private void valueUnBoundListener(String name) {
        TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
        List<HttpSessionBindingListener> listeners = configManager.getSessionBindingListeners();
        Object value = this.getAttribute(name);
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name);
        if (value instanceof HttpSessionBindingListener) {
            for (HttpSessionBindingListener listener : listeners) {
                log.logMessage(LogLevel.DEBUG, "HttpSessionBindingListener:[{0}] will be valueUnbound", new Object[]{listener});
                listener.valueUnbound(event);
                log.logMessage(LogLevel.DEBUG, "HttpSessionBindingListener:[{0}] valueUnbound", new Object[]{listener});
            }
        }
    }

    private void setAttributeListener(String name, Object value, Object oldValue) {
        block4: {
            TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
            List<HttpSessionAttributeListener> listeners = configManager.getSessionAttributeListeners();
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, value);
            if (value == null) break block4;
            if (oldValue == null) {
                for (HttpSessionAttributeListener listener : listeners) {
                    log.logMessage(LogLevel.DEBUG, "HttpSessionAttributeListener:[{0}] will be attributeAdded", new Object[]{listener});
                    listener.attributeAdded(event);
                    log.logMessage(LogLevel.DEBUG, "HttpSessionActivationListener:[{0}] attributeAdded", new Object[]{listener});
                }
            } else {
                for (HttpSessionAttributeListener listener : listeners) {
                    log.logMessage(LogLevel.DEBUG, "HttpSessionAttributeListener:[{0}] will be attributeReplaced,the oldValue:[{1}]", new Object[]{listener, oldValue});
                    listener.attributeReplaced(event);
                    log.logMessage(LogLevel.DEBUG, "HttpSessionAttributeListener:[{0}] attributeReplaced", new Object[]{listener});
                }
            }
        }
    }

    public void removeAttribute(String name) {
        this.assertValid("removeAttribute");
        this.assertAttributeNameForModification("removeAttribute", name);
        this.setAttribute(name, null);
        this.removeAttributeListener(name);
        this.valueUnBoundListener(name);
    }

    private void removeAttributeListener(String name) {
        TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
        List<HttpSessionAttributeListener> listeners = configManager.getSessionAttributeListeners();
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name);
        for (HttpSessionAttributeListener listener : listeners) {
            log.logMessage(LogLevel.DEBUG, "HttpSessionAttributeListener:[{0}] will be attributeRemoved", new Object[]{listener});
            listener.attributeRemoved(event);
            log.logMessage(LogLevel.DEBUG, "HttpSessionAttributeListener:[{0}]  attributeRemoved", new Object[]{listener});
        }
    }

    @Override
    public void invalidate() {
        this.assertValid("invalidate");
        if (this.invalidated) {
            return;
        }
        if (!StringUtil.isBlank((String)this.webContext.getSessionConfig().getSessionManagerBeanId())) {
            SessionManager manager = SessionManagerFactory.getSessionManager(this.webContext.getSessionConfig().getSessionManagerBeanId(), this.getClass().getClassLoader());
            manager.expireSession(this);
        }
        this.fireEvent(EventType.INVALIDATED);
        Set<String> attrNames = this.getAttributeNameSet();
        for (String name : attrNames) {
            this.removeAttribute(name);
        }
        this.sessionInternal.invalidate();
        this.invalidated = true;
    }

    public void clear() {
        this.assertValid("clear");
        this.sessionInternal.invalidate();
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public boolean isNew() {
        this.assertValid("isNew");
        return this.isNew;
    }

    protected void assertModel(String methodName) {
        if (this.model == null) {
            throw new IllegalStateException("Cannot call method " + methodName + ": the session has not been initialized");
        }
    }

    protected void assertValid(String methodName) {
        this.assertModel(methodName);
        if (this.invalidated) {
            throw new IllegalStateException("Cannot call method " + methodName + ": the session has already invalidated");
        }
    }

    protected void assertAttributeNameForModification(String methodName, String attrName) {
        if (this.modelKey.equals(attrName)) {
            throw new IllegalArgumentException("Cannot call method " + methodName + " with attribute " + attrName);
        }
    }

    public void commit(boolean commitHeaders) {
        String[] storeNames = this.webContext.getSessionConfig().getStores().getStoreNames();
        HashMap mappings = CollectionUtil.createHashMap();
        Map mayNotBeCommitted = null;
        boolean modified = false;
        for (Map.Entry<String, SessionAttribute> entry : this.attrs.entrySet()) {
            StringBuilder buf;
            String attrName = entry.getKey();
            SessionAttribute attr = entry.getValue();
            if (!attr.isModified()) continue;
            String storeName = attr.getStoreName();
            SessionStore store = attr.getStore();
            if (this.isApplicableToCommit(store, commitHeaders)) {
                StoreData data = (StoreData)mappings.get(storeName);
                if (data == null) {
                    data = new StoreData(storeName, store);
                    mappings.put(storeName, data);
                }
                Map storeAttrs = data.attrs;
                Object attrValue = attr.getValue();
                if (attrValue instanceof SessionModel) {
                    attrValue = this.webContext.getSessionConfig().getSessionModelEncoders()[0].encode((SessionModel)attrValue);
                } else {
                    modified = true;
                }
                storeAttrs.put(attrName, attrValue);
                attr.setModified(false);
                continue;
            }
            if (commitHeaders) continue;
            if (mayNotBeCommitted == null) {
                mayNotBeCommitted = CollectionUtil.createLinkedHashMap();
            }
            if ((buf = (StringBuilder)mayNotBeCommitted.get(storeName)) == null) {
                buf = new StringBuilder();
                mayNotBeCommitted.put(storeName, buf);
            }
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(attrName);
        }
        if (mayNotBeCommitted != null) {
            for (Map.Entry<String, SessionAttribute> entry : mayNotBeCommitted.entrySet()) {
                String storeName = entry.getKey();
                SessionStore store = this.webContext.getSessionConfig().getStores().getStore(storeName);
                String attrNames = ((StringBuilder)((Object)entry.getValue())).toString();
                log.logMessage(LogLevel.WARN, "The following attributes may not be saved in {}[id={}], because the response has already been committed: {}", new Object[]{store.getClass().getSimpleName(), storeName, attrNames});
            }
        }
        if (!(modified || this.cleared || this.webContext.getSessionConfig().isKeepInTouch())) {
            return;
        }
        for (StoreData storeData : mappings.values()) {
            storeData.store.commit(storeData.attrs, this.getId(), new StoreContextImpl(storeData.storeName));
            this.clearingStores.remove(storeData.storeName);
        }
        if (this.cleared) {
            Iterator<String> i = this.clearingStores.iterator();
            while (i.hasNext()) {
                String string = i.next();
                SessionStore store = this.webContext.getSessionConfig().getStores().getStore(string);
                if (this.isApplicableToCommit(store, commitHeaders)) {
                    Map<String, Object> storeAttrs = Collections.emptyMap();
                    store.commit(storeAttrs, this.sessionID, new StoreContextImpl(string));
                    i.remove();
                    continue;
                }
                if (commitHeaders) continue;
                log.logMessage(LogLevel.WARN, "Session was cleared, but the data in {}[id={}] may not be cleared, because the response has already been committed.", new Object[]{store.getClass().getSimpleName(), string});
            }
        }
        this.sessionPassivated();
    }

    private void sessionPassivated() {
        TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
        List<HttpSessionActivationListener> listeners = configManager.getSessionActivationListeners();
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
        for (HttpSessionActivationListener listener : listeners) {
            log.logMessage(LogLevel.DEBUG, "HttpSessionActivationListener:[{0}] will be passivated", new Object[]{listener});
            listener.sessionWillPassivate(event);
            log.logMessage(LogLevel.DEBUG, "HttpSessionActivationListener:[{0}] passivated", new Object[]{listener});
        }
    }

    private boolean isApplicableToCommit(SessionStore store, boolean commitHeaders) {
        boolean isHttpHeaderStore = store instanceof HttpHeaderSessionStore;
        return commitHeaders == isHttpHeaderStore;
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException("No longer supported method: getSessionContext");
    }

    @Deprecated
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    @Deprecated
    public String[] getValueNames() {
        this.assertValid("getValueNames");
        Set<String> names = this.getAttributeNameSet();
        return names.toArray(new String[names.size()]);
    }

    @Deprecated
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    @Deprecated
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        ToStringBuilder.MapBuilder attrsBuilder = new ToStringBuilder.MapBuilder().setPrintCount(true).setSortKeys(true);
        mb.append("sessionID", (Object)this.sessionID);
        mb.append("model", (Object)this.model);
        mb.append("isNew", (Object)this.isNew);
        mb.append("invalidated", (Object)this.invalidated);
        attrsBuilder.appendAll(this.attrs);
        attrsBuilder.remove(this.modelKey);
        mb.append("attrs", (Object)attrsBuilder);
        return new ToStringBuilder().append((Object)"HttpSession").append((Object)mb).toString();
    }

    private void fireEvent(EventType event) {
        this.fireSessionIntercept(event);
        this.fireSessionListener(event);
    }

    private void fireSessionIntercept(EventType event) {
        for (SessionInterceptor l : this.getSessionWebContext().getSessionConfig().getSessionInterceptors()) {
            if (!(l instanceof SessionLifecycleListener)) continue;
            SessionLifecycleListener listener = (SessionLifecycleListener)l;
            try {
                switch (event) {
                    case RECREATED: {
                        listener.sessionInvalidated(this);
                        break;
                    }
                    case CREATED: {
                        listener.sessionCreated(this);
                        break;
                    }
                    case VISITED: {
                        listener.sessionVisited(this);
                        break;
                    }
                    case INVALIDATED: {
                        listener.sessionInvalidated(this);
                        break;
                    }
                    default: {
                        Assert.unreachableCode();
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.errorMessage("Listener \"" + listener.getClass().getSimpleName() + "\" failed", (Throwable)e, new Object[0]);
            }
        }
    }

    private void fireSessionListener(EventType event) {
        TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
        List<HttpSessionListener> listeners = configManager.getSessionListeners();
        HttpSessionEvent sessionEvent = new HttpSessionEvent((HttpSession)this);
        for (HttpSessionListener listener : listeners) {
            if (event == EventType.CREATED || event == EventType.RECREATED) {
                log.logMessage(LogLevel.DEBUG, "HttpSessionListener:[{0}] will be sessionCreated", new Object[]{listener});
                listener.sessionCreated(sessionEvent);
                log.logMessage(LogLevel.DEBUG, "HttpSessionListener:[{0}] sessionCreated", new Object[]{listener});
                continue;
            }
            if (event != EventType.INVALIDATED) continue;
            log.logMessage(LogLevel.DEBUG, "HttpSessionListener:[{0}] will be sessionDestroyed", new Object[]{listener});
            listener.sessionDestroyed(sessionEvent);
            log.logMessage(LogLevel.DEBUG, "HttpSessionListener:[{0}] sessionDestroyed", new Object[]{listener});
        }
    }

    private void sessionActivated() {
        TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
        List<HttpSessionActivationListener> listeners = configManager.getSessionActivationListeners();
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
        for (HttpSessionActivationListener listener : listeners) {
            log.logMessage(LogLevel.DEBUG, "HttpSessionActivationListener:[{0}] will be activated", new Object[]{listener});
            listener.sessionDidActivate(event);
            log.logMessage(LogLevel.DEBUG, "HttpSessionActivationListener:[{0}] activated", new Object[]{listener});
        }
    }

    private class HttpSessionInternal
    implements HttpSession {
        private HttpSessionInternal() {
        }

        public String getId() {
            return SessionImpl.this.getId();
        }

        public long getCreationTime() {
            return SessionImpl.this.model == null ? 0L : SessionImpl.this.model.getCreationTime();
        }

        public long getLastAccessedTime() {
            return SessionImpl.this.getLastAccessedTime();
        }

        public int getMaxInactiveInterval() {
            return SessionImpl.this.getMaxInactiveInterval();
        }

        public void setMaxInactiveInterval(int maxInactiveInterval) {
            SessionImpl.this.setMaxInactiveInterval(maxInactiveInterval);
        }

        public ServletContext getServletContext() {
            return SessionImpl.this.getServletContext();
        }

        public Object getAttribute(String name) {
            Object value;
            SessionAttribute attr = (SessionAttribute)SessionImpl.this.attrs.get(name);
            SessionConfig sessionConfig = SessionImpl.this.webContext.getSessionConfig();
            if (attr == null) {
                String storeName = sessionConfig.getStoreMappings().getStoreNameForAttribute(name);
                if (storeName == null) {
                    value = null;
                } else {
                    attr = new SessionAttribute(name, SessionImpl.this, storeName, new StoreContextImpl(storeName));
                    value = attr.getValue();
                    if (value != null && SessionImpl.this.modelKey.equals(name)) {
                        value = this.decodeSessionModel(value);
                        attr.updateValue(value);
                    }
                    if (value != null) {
                        SessionImpl.this.attrs.put(name, attr);
                    }
                }
            } else {
                value = attr.getValue();
            }
            return this.interceptGet(name, value);
        }

        private Object interceptGet(String name, Object value) {
            for (SessionInterceptor l : SessionImpl.this.getSessionWebContext().getSessionConfig().getSessionInterceptors()) {
                if (!(l instanceof SessionAttributeInterceptor)) continue;
                SessionAttributeInterceptor interceptor = (SessionAttributeInterceptor)l;
                value = interceptor.onRead(name, value);
            }
            return value;
        }

        private Object decodeSessionModel(Object value) {
            SessionModelEncoder encoder;
            SessionModelEncoder[] encoders;
            SessionModel.Factory factory = new SessionModel.Factory(){

                @Override
                public SessionModel newInstance(String sessionID, long creationTime, long lastAccessedTime, int maxInactiveInterval) {
                    return new SessionModelImpl(sessionID, creationTime, lastAccessedTime, maxInactiveInterval);
                }
            };
            SessionModel model = null;
            SessionModelEncoder[] sessionModelEncoderArray = encoders = SessionImpl.this.webContext.getSessionConfig().getSessionModelEncoders();
            int n = sessionModelEncoderArray.length;
            for (int i = 0; i < n && (model = (encoder = sessionModelEncoderArray[i]).decode(value, factory)) == null; ++i) {
            }
            if (model == null) {
                log.logMessage(LogLevel.WARN, "Could not decode session model {} by {} encoders", new Object[]{value, encoders.length});
            }
            return model;
        }

        public Enumeration<String> getAttributeNames() {
            return SessionImpl.this.getAttributeNames();
        }

        public void setAttribute(String name, Object value) {
            value = this.interceptSet(name, value);
            SessionAttribute attr = (SessionAttribute)SessionImpl.this.attrs.get(name);
            SessionConfig sessionConfig = SessionImpl.this.webContext.getSessionConfig();
            if (attr == null) {
                String storeName = sessionConfig.getStoreMappings().getStoreNameForAttribute(name);
                if (storeName == null) {
                    throw new IllegalArgumentException("No storage configured for session attribute: " + name);
                }
                attr = new SessionAttribute(name, SessionImpl.this, storeName, new StoreContextImpl(storeName));
                SessionImpl.this.attrs.put(name, attr);
            }
            attr.setValue(value);
        }

        private Object interceptSet(String name, Object value) {
            for (SessionInterceptor l : SessionImpl.this.getSessionWebContext().getSessionConfig().getSessionInterceptors()) {
                if (!(l instanceof SessionAttributeInterceptor)) continue;
                SessionAttributeInterceptor interceptor = (SessionAttributeInterceptor)l;
                value = interceptor.onWrite(name, value);
            }
            return value;
        }

        public void removeAttribute(String name) {
            SessionImpl.this.removeAttribute(name);
        }

        public void invalidate() {
            SessionConfig sessionConfig = SessionImpl.this.webContext.getSessionConfig();
            Object[] storeNames = sessionConfig.getStores().getStoreNames();
            SessionImpl.this.attrs.clear();
            SessionImpl.this.cleared = true;
            SessionImpl.this.clearingStores.addAll(CollectionUtil.asList((Object[])storeNames));
            for (Object storeName : storeNames) {
                SessionStore store = sessionConfig.getStores().getStore((String)storeName);
                store.invaldiate(SessionImpl.this.sessionID, new StoreContextImpl((String)storeName));
            }
            if (SessionImpl.this.model == null) {
                SessionImpl.this.model = new SessionModelImpl(SessionImpl.this);
            } else {
                SessionImpl.this.model.reset();
            }
        }

        public boolean isNew() {
            return SessionImpl.this.isNew();
        }

        @Deprecated
        public HttpSessionContext getSessionContext() {
            return SessionImpl.this.getSessionContext();
        }

        @Deprecated
        public Object getValue(String name) {
            return SessionImpl.this.getValue(name);
        }

        @Deprecated
        public String[] getValueNames() {
            return SessionImpl.this.getValueNames();
        }

        @Deprecated
        public void putValue(String name, Object value) {
            SessionImpl.this.putValue(name, value);
        }

        @Deprecated
        public void removeValue(String name) {
            SessionImpl.this.removeValue(name);
        }
    }

    private class StoreContextImpl
    implements SessionStore.StoreContext {
        private String storeName;

        public StoreContextImpl(String storeName) {
            this.storeName = storeName;
        }

        @Override
        public Object getState() {
            return SessionImpl.this.storeStates.get(this.storeName);
        }

        @Override
        public void setState(Object stateObject) {
            if (stateObject == null) {
                SessionImpl.this.storeStates.remove(this.storeName);
            } else {
                SessionImpl.this.storeStates.put(this.storeName, stateObject);
            }
        }

        @Override
        public SessionStore.StoreContext getStoreContext(String storeName) {
            return new StoreContextImpl(storeName);
        }

        @Override
        public SessionWebContext getSessionWebContext() {
            return SessionImpl.this.getSessionWebContext();
        }

        @Override
        public HttpSession getHttpSession() {
            return SessionImpl.this.sessionInternal;
        }
    }

    private static class StoreData {
        private final String storeName;
        private final SessionStore store;
        private final Map<String, Object> attrs = CollectionUtil.createHashMap();

        private StoreData(String storeName, SessionStore store) {
            this.storeName = storeName;
            this.store = store;
        }
    }

    private static enum EventType {
        CREATED,
        RECREATED,
        INVALIDATED,
        VISITED;

    }
}

