/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.impl;

import javax.servlet.http.HttpSession;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.webcontext.session.SessionConfig;
import org.tinygroup.weblayer.webcontext.session.SessionLifecycleListener;

public class SessionLifecycleLogger
implements SessionLifecycleListener {
    private static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.DEBUG;
    private static final LogLevel DEFAULT_VISITED_LOG_LEVEL = LogLevel.TRACE;
    private final Logger log = LoggerFactory.getLogger(SessionLifecycleLogger.class);
    private LogLevel logLevel;
    private LogLevel visitLogLevel;

    public void setLogLevel(LogLevel level) {
        this.logLevel = level;
    }

    public void setVisitLogLevel(LogLevel level) {
        this.visitLogLevel = level;
    }

    @Override
    public void init(SessionConfig sessionConfig) {
        if (this.logLevel == null) {
            this.logLevel = DEFAULT_LOG_LEVEL;
        }
        if (this.visitLogLevel == null) {
            this.visitLogLevel = DEFAULT_VISITED_LOG_LEVEL;
        }
    }

    @Override
    public void sessionCreated(HttpSession session) {
        this.log.logMessage(this.logLevel, "session created, id=" + session.getId());
    }

    @Override
    public void sessionInvalidated(HttpSession session) {
        this.log.logMessage(this.logLevel, "session invalidated, id=" + session.getId());
    }

    @Override
    public void sessionVisited(HttpSession session) {
        this.log.logMessage(this.visitLogLevel, "session visited, id=" + session.getId());
    }
}

