/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.impl;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.webcontext.AbstractRequestWrapper;
import org.tinygroup.weblayer.webcontext.AbstractResponseWrapper;
import org.tinygroup.weblayer.webcontext.AbstractWebContextWrapper;
import org.tinygroup.weblayer.webcontext.WebContextException;
import org.tinygroup.weblayer.webcontext.session.SessionConfig;
import org.tinygroup.weblayer.webcontext.session.SessionManager;
import org.tinygroup.weblayer.webcontext.session.SessionWebContext;
import org.tinygroup.weblayer.webcontext.session.impl.SessionImpl;
import org.tinygroup.weblayer.webcontext.session.model.SessionManagerFactory;
import org.tinygroup.weblayer.webcontext.util.CookieSupport;

public class SessionWebContextImpl
extends AbstractWebContextWrapper
implements SessionWebContext {
    private static final Logger log = LoggerFactory.getLogger(SessionWebContextImpl.class);
    private SessionConfig sessionConfig;
    private boolean requestedSessionIDParsed;
    private String requestedSessionID;
    private boolean requestedSessionIDFromCookie;
    private boolean requestedSessionIDFromURL;
    private SessionImpl session;
    private boolean sessionReturned;

    public SessionWebContextImpl(WebContext wrappedContext, SessionConfig sessionConfig) {
        super(wrappedContext);
        this.sessionConfig = sessionConfig;
        this.setRequest((HttpServletRequest)new SessionRequestWrapper(wrappedContext.getRequest()));
        this.setResponse((HttpServletResponse)new SessionResponseWrapper(wrappedContext.getResponse()));
    }

    @Override
    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    @Override
    public boolean isSessionInvalidated() {
        return this.session == null ? false : this.session.isInvalidated();
    }

    @Override
    public void clear() {
        if (this.session != null) {
            this.session.clear();
        }
    }

    public String getRequestedSessionID() {
        this.ensureRequestedSessionID();
        return this.requestedSessionID;
    }

    public boolean isRequestedSessionIDFromCookie() {
        this.ensureRequestedSessionID();
        return this.requestedSessionIDFromCookie;
    }

    public boolean isRequestedSessionIDFromURL() {
        this.ensureRequestedSessionID();
        return this.requestedSessionIDFromURL;
    }

    public boolean isRequestedSessionIDValid() {
        HttpSession session = this.getSession(false);
        return session != null && session.getId().equals(this.requestedSessionID);
    }

    private void ensureRequestedSessionID() {
        if (!this.requestedSessionIDParsed) {
            if (this.sessionConfig.getId().isCookieEnabled()) {
                this.requestedSessionID = this.decodeSessionIDFromCookie();
                boolean bl = this.requestedSessionIDFromCookie = this.requestedSessionID != null;
            }
            if (this.requestedSessionID == null && this.sessionConfig.getId().isUrlEncodeEnabled()) {
                this.requestedSessionID = this.decodeSessionIDFromURL();
                this.requestedSessionIDFromURL = this.requestedSessionID != null;
            }
        }
    }

    public void encodeSessionIDIntoCookie() {
        this.writeSessionIDCookie(this.session.getId());
    }

    public void clearSessionIDFromCookie() {
        this.writeSessionIDCookie("");
    }

    private void writeSessionIDCookie(String cookieValue) {
        int cookieMaxAge;
        String cookiePath;
        SessionConfig.CookieConfig cookieConfig = this.sessionConfig.getId().getCookie();
        CookieSupport cookie = new CookieSupport(cookieConfig.getName(), cookieValue);
        String cookieDomain = cookieConfig.getDomain();
        if (!StringUtil.isEmpty((String)cookieDomain)) {
            cookie.setDomain(cookieDomain);
        }
        if (!StringUtil.isEmpty((String)(cookiePath = cookieConfig.getPath()))) {
            cookie.setPath(cookiePath);
        }
        if ((cookieMaxAge = cookieConfig.getMaxAge()) > 0) {
            cookie.setMaxAge(cookieMaxAge);
        }
        cookie.setHttpOnly(cookieConfig.isHttpOnly());
        cookie.setSecure(cookieConfig.isSecure());
        log.logMessage(LogLevel.DEBUG, "{}", new Object[]{cookie});
        cookie.addCookie(this.getResponse());
    }

    public String decodeSessionIDFromCookie() {
        Cookie[] cookies = this.getRequest().getCookies();
        if (cookies != null) {
            String sessionCookieName = this.sessionConfig.getId().getCookie().getName();
            for (Cookie cookie : cookies) {
                String sessionID;
                if (!cookie.getName().equals(sessionCookieName) || (sessionID = StringUtil.trimToNull((String)cookie.getValue())) == null) continue;
                return sessionID;
            }
        }
        return null;
    }

    public String encodeSessionIDIntoURL(String url) {
        HttpSession session = this.getRequest().getSession(false);
        if (session != null && (session.isNew() || this.isRequestedSessionIDFromURL() && !this.isRequestedSessionIDFromCookie())) {
            String sessionID = session.getId();
            String keyName = this.getSessionConfig().getId().getUrlEncode().getName();
            int keyNameLength = keyName.length();
            int urlLength = url.length();
            int urlQueryIndex = url.indexOf(63);
            if (urlQueryIndex >= 0) {
                urlLength = urlQueryIndex;
            }
            boolean found = false;
            int keyBeginIndex = url.indexOf(59);
            while (keyBeginIndex >= 0 && keyBeginIndex < urlLength) {
                if (urlLength - ++keyBeginIndex > keyNameLength && url.regionMatches(keyBeginIndex, keyName, 0, keyNameLength) && url.charAt(keyBeginIndex + keyNameLength) == '=') {
                    int valueBeginIndex = keyBeginIndex + keyNameLength + 1;
                    int valueEndIndex = url.indexOf(59, valueBeginIndex);
                    if (valueEndIndex < 0) {
                        valueEndIndex = urlLength;
                    }
                    if (!url.regionMatches(valueBeginIndex, sessionID, 0, sessionID.length())) {
                        url = url.substring(0, valueBeginIndex) + sessionID + url.substring(valueEndIndex);
                    }
                    found = true;
                    break;
                }
                keyBeginIndex = url.indexOf(59, keyBeginIndex + 1);
            }
            if (!found) {
                url = url.substring(0, urlLength) + ';' + keyName + '=' + sessionID + url.substring(urlLength);
            }
        }
        return url;
    }

    public String decodeSessionIDFromURL() {
        String uri = this.getRequest().getRequestURI();
        String keyName = this.sessionConfig.getId().getUrlEncode().getName();
        int uriLength = uri.length();
        int keyNameLength = keyName.length();
        int keyBeginIndex = uri.indexOf(59);
        while (keyBeginIndex >= 0) {
            if (uriLength - ++keyBeginIndex > keyNameLength && uri.regionMatches(keyBeginIndex, keyName, 0, keyNameLength) && uri.charAt(keyBeginIndex + keyNameLength) == '=') {
                int valueBeginIndex = keyBeginIndex + keyNameLength + 1;
                int valueEndIndex = uri.indexOf(59, valueBeginIndex);
                if (valueEndIndex < 0) {
                    valueEndIndex = uriLength;
                }
                return uri.substring(valueBeginIndex, valueEndIndex);
            }
            keyBeginIndex = uri.indexOf(59, keyBeginIndex + 1);
        }
        return null;
    }

    public HttpSession getSession(boolean create) {
        if (this.session != null && this.sessionReturned) {
            return this.session;
        }
        if (this.session == null) {
            this.ensureRequestedSessionID();
            String sessionID = this.requestedSessionID;
            boolean isNew = false;
            if (sessionID == null) {
                if (!create) {
                    return null;
                }
                sessionID = this.sessionConfig.getId().getGenerator().generateSessionID();
                isNew = true;
            }
            this.session = new SessionImpl(sessionID, this, isNew, create);
            if (!StringUtil.isBlank((String)this.sessionConfig.getSessionManagerBeanId())) {
                SessionManager manager = SessionManagerFactory.getSessionManager(this.sessionConfig.getSessionManagerBeanId(), this.getClass().getClassLoader());
                manager.addSession(this.session);
            }
        }
        if (this.session.isNew() && !create) {
            return null;
        }
        if (this.sessionConfig.getId().isCookieEnabled() && !this.session.getId().equals(this.requestedSessionID)) {
            if (this.getResponse().isCommitted()) {
                throw new IllegalStateException("Failed to create a new session because the responseWrapper was already committed");
            }
            this.encodeSessionIDIntoCookie();
        }
        this.sessionReturned = true;
        return this.session;
    }

    @Override
    public void commitHeaders() throws WebContextException {
        if (!this.sessionReturned) {
            return;
        }
        if (this.session.isInvalidated()) {
            this.clearSessionIDFromCookie();
        }
        this.session.commit(true);
    }

    public void commit() {
        if (!this.sessionReturned) {
            return;
        }
        this.session.commit(false);
    }

    private class SessionResponseWrapper
    extends AbstractResponseWrapper {
        public SessionResponseWrapper(HttpServletResponse response) {
            super(SessionWebContextImpl.this, response);
        }

        public String encodeURL(String url) {
            if (SessionWebContextImpl.this.sessionConfig.getId().isUrlEncodeEnabled()) {
                url = SessionWebContextImpl.this.encodeSessionIDIntoURL(url);
            }
            return url;
        }

        public String encodeRedirectURL(String url) {
            if (SessionWebContextImpl.this.sessionConfig.getId().isUrlEncodeEnabled()) {
                url = SessionWebContextImpl.this.encodeSessionIDIntoURL(url);
            }
            return url;
        }

        @Deprecated
        public String encodeUrl(String url) {
            return this.encodeURL(url);
        }

        @Deprecated
        public String encodeRedirectUrl(String url) {
            return this.encodeRedirectURL(url);
        }
    }

    private class SessionRequestWrapper
    extends AbstractRequestWrapper {
        public SessionRequestWrapper(HttpServletRequest request) {
            super(SessionWebContextImpl.this, request);
        }

        public String getRequestedSessionId() {
            return SessionWebContextImpl.this.getRequestedSessionID();
        }

        public boolean isRequestedSessionIdFromCookie() {
            return SessionWebContextImpl.this.isRequestedSessionIDFromCookie();
        }

        public boolean isRequestedSessionIdFromURL() {
            return SessionWebContextImpl.this.isRequestedSessionIDFromURL();
        }

        public boolean isRequestedSessionIdValid() {
            return SessionWebContextImpl.this.isRequestedSessionIDValid();
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public HttpSession getSession(boolean create) {
            return SessionWebContextImpl.this.getSession(create);
        }

        @Deprecated
        public boolean isRequestedSessionIdFromUrl() {
            return this.isRequestedSessionIdFromURL();
        }
    }
}

