/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.model;

import java.util.Collection;
import java.util.Set;
import org.tinygroup.cache.Cache;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.weblayer.webcontext.session.Session;
import org.tinygroup.weblayer.webcontext.session.SessionManager;

public class CacheSessionManager
implements SessionManager {
    public static final String SESSION_GROUP = "sessionGroup";
    private final Object lock = new Object();
    private Cache sessionCaches;

    public Cache getSessionCaches() {
        return this.sessionCaches;
    }

    public void setSessionCaches(Cache sessionCaches) {
        this.sessionCaches = sessionCaches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSession(Session session) {
        Object object = this.lock;
        synchronized (object) {
            this.sessionCaches.put(SESSION_GROUP, session.getSessionID(), (Object)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireSession(Session session) {
        Object object = this.lock;
        synchronized (object) {
            this.sessionCaches.remove(SESSION_GROUP, session.getSessionID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session[] queryAllSessions() {
        Object object = this.lock;
        synchronized (object) {
            Set keys = this.sessionCaches.getGroupKeys(SESSION_GROUP);
            if (CollectionUtil.isEmpty((Collection)keys)) {
                return new Session[0];
            }
            Session[] Sessions = new Session[keys.size()];
            int index = 0;
            for (String key : keys) {
                Sessions[index++] = this.querySessionById(key);
            }
            return Sessions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session querySessionById(String sessionId) {
        Object object = this.lock;
        synchronized (object) {
            return (Session)this.sessionCaches.get(SESSION_GROUP, sessionId);
        }
    }
}

