/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.model;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tinygroup.weblayer.webcontext.session.Session;
import org.tinygroup.weblayer.webcontext.session.SessionManager;

public class DefaultSessionManager
implements SessionManager {
    private static SessionManager manager;
    private final Object lock = new Object();
    protected Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();

    private DefaultSessionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SessionManager getSingleton() {
        if (manager != null) return manager;
        Class<SessionManager> clazz = SessionManager.class;
        synchronized (SessionManager.class) {
            if (manager != null) return manager;
            manager = new DefaultSessionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSession(Session session) {
        Object object = this.lock;
        synchronized (object) {
            this.sessions.put(session.getSessionID(), session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireSession(Session session) {
        Object object = this.lock;
        synchronized (object) {
            this.sessions.remove(session.getSessionID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session[] queryAllSessions() {
        Object object = this.lock;
        synchronized (object) {
            Session[] httpSessions = new Session[this.sessions.size()];
            int index = 0;
            for (Session session : this.sessions.values()) {
                httpSessions[index++] = session;
            }
            return httpSessions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session querySessionById(String sessionId) {
        Object object = this.lock;
        synchronized (object) {
            return this.sessions.get(sessionId);
        }
    }
}

