/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.store.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.commons.tools.ToStringBuilder;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.weblayer.webcontext.session.ExactMatchesOnlySessionStore;
import org.tinygroup.weblayer.webcontext.session.SessionStore;
import org.tinygroup.weblayer.webcontext.session.store.AbstractCookieStore;
import org.tinygroup.weblayer.webcontext.session.valueencode.SessionValueEncoder;
import org.tinygroup.weblayer.webcontext.session.valueencode.impl.SimpleValueEncoder;

public class SingleValuedCookieStoreImpl
extends AbstractCookieStore
implements ExactMatchesOnlySessionStore {
    private String[] attrNames;
    private SessionValueEncoder[] encoders;

    @Override
    public void initAttributeNames(String[] attrNames) {
        this.attrNames = attrNames;
        Assert.assertTrue((attrNames.length <= 1 ? 1 : 0) != 0, (String)"Session store %s supports only 1 mapping to attribute name", (Object[])new Object[]{this.getName()});
    }

    public void setValueEncoders(SessionValueEncoder[] encoders) {
        this.encoders = encoders;
    }

    @Override
    protected void init() throws Exception {
        if (ArrayUtil.isEmptyArray((Object)this.encoders)) {
            this.encoders = new SessionValueEncoder[]{this.createDefaultSessionValueEncoder()};
        }
    }

    protected SessionValueEncoder createDefaultSessionValueEncoder() throws Exception {
        SimpleValueEncoder simpleValueEncoder = new SimpleValueEncoder();
        simpleValueEncoder.afterPropertiesSet();
        return simpleValueEncoder;
    }

    @Override
    public Iterable<String> getAttributeNames(String sessionID, SessionStore.StoreContext storeContext) {
        State state = this.getState(storeContext);
        return state.attributes.keySet();
    }

    @Override
    public Object loadAttribute(String attrName, String sessionID, SessionStore.StoreContext storeContext) {
        State state = this.getState(storeContext);
        return state.attributes.get(attrName);
    }

    @Override
    public void invaldiate(String sessionID, SessionStore.StoreContext storeContext) {
        State state = this.getState(storeContext);
        if (!this.isSurvivesInInvalidating()) {
            state.attributes.clear();
        }
    }

    @Override
    public void commit(Map<String, Object> modifiedAttrs, String sessionID, SessionStore.StoreContext storeContext) {
        State state = this.getState(storeContext);
        if (state.cookieCommitted) {
            return;
        }
        state.cookieCommitted = true;
        String attrName = this.attrNames[0];
        if (modifiedAttrs.containsKey(attrName)) {
            Object attrValue = modifiedAttrs.get(attrName);
            if (attrValue == null) {
                this.log.logMessage(LogLevel.DEBUG, "Remove from session: {}", new Object[]{attrName});
                state.attributes.remove(attrName);
            } else {
                this.log.logMessage(LogLevel.DEBUG, "Set to session: {} = {}", new Object[]{attrName, attrValue});
                state.attributes.put(attrName, attrValue);
            }
        }
        String cookieState = null;
        if (!state.attributes.isEmpty()) {
            try {
                cookieState = this.encoders[0].encode(state.attributes.get(attrName), storeContext);
            }
            catch (Exception e) {
                this.log.logMessage(LogLevel.WARN, "Failed to encode session state", (Throwable)e);
            }
        }
        cookieState = StringUtil.trimToEmpty(cookieState);
        this.writeCookie(storeContext.getSessionWebContext().getResponse(), this.getName(), cookieState);
    }

    private State getState(SessionStore.StoreContext storeContext) {
        State state = (State)storeContext.getState();
        if (state == null) {
            state = new State();
            storeContext.setState(state);
        }
        this.ensureCookieLoading(state, storeContext.getSessionWebContext().getRequest(), storeContext);
        return state;
    }

    private void ensureCookieLoading(State state, HttpServletRequest request, SessionStore.StoreContext storeContext) {
        if (state.cookieLoaded) {
            return;
        }
        state.cookieLoaded = true;
        state.requestCookieValue = this.readCookie(request);
        state.attributes = this.decodeCookieValue(state.requestCookieValue, storeContext);
    }

    private String readCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        String cookieValue = null;
        for (Cookie cookie : cookies) {
            String cookieName = cookie.getName();
            if (!this.getName().equals(cookieName)) continue;
            cookieValue = cookie.getValue();
            this.log.logMessage(LogLevel.DEBUG, "[{}] Loading cookie: {}[length={}]={}", new Object[]{this.getStoreName(), this.getName(), cookie.getValue().length(), cookie.getValue()});
            break;
        }
        return cookieValue;
    }

    private Map<String, Object> decodeCookieValue(String cookieValue, SessionStore.StoreContext storeContext) {
        HashMap attrs = CollectionUtil.createHashMap((int)4);
        if (cookieValue == null) {
            return attrs;
        }
        LinkedList encoderExceptions = null;
        for (SessionValueEncoder encoder : this.encoders) {
            try {
                attrs.put(this.attrNames[0], encoder.decode(cookieValue, storeContext));
                this.log.logMessage(LogLevel.DEBUG, "Succeeded decoding cookieValue using {}", new Object[]{encoder});
                break;
            }
            catch (Exception e) {
                if (encoderExceptions == null) {
                    encoderExceptions = CollectionUtil.createLinkedList();
                }
                encoderExceptions.add(e);
                this.log.logMessage(LogLevel.TRACE, "Failure decoding cookieValue using {}: {}", new Object[]{encoder, e.getMessage()});
            }
        }
        if (attrs.isEmpty() && encoderExceptions != null) {
            ToStringBuilder buf = new ToStringBuilder();
            buf.append((Object)"Failed to decode cookie value: ").append((Object)cookieValue);
            int i = 0;
            for (Exception e : encoderExceptions) {
                buf.format("\n  Encoder #%d - %s threw %s", new Object[]{i + 1, this.encoders[i].getClass().getSimpleName(), e});
            }
            this.log.logMessage(LogLevel.WARN, buf.toString());
        } else {
            int attrCount = attrs.size();
            ToStringBuilder buf = new ToStringBuilder();
            buf.format("Found %d attributes:", new Object[]{attrCount});
            if (!attrs.isEmpty()) {
                buf.append((Object)new ToStringBuilder.MapBuilder().setPrintCount(true).setSortKeys(true).appendAll((Map)attrs));
            }
            this.log.logMessage(LogLevel.DEBUG, buf.toString());
        }
        return attrs;
    }

    @Override
    protected void toString(ToStringBuilder.MapBuilder mb) {
        super.toString(mb);
        mb.append("encoders", (Object)this.encoders);
    }

    private class State {
        private boolean cookieLoaded;
        private boolean cookieCommitted;
        private String requestCookieValue;
        private Map<String, Object> attributes;

        private State() {
        }
    }
}

