/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.valueencode;

import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.commons.tools.StringEscapeUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.support.BeanSupport;
import org.tinygroup.weblayer.webcontext.session.SessionStore;
import org.tinygroup.weblayer.webcontext.session.encrypter.Encrypter;
import org.tinygroup.weblayer.webcontext.session.exception.SessionEncoderException;
import org.tinygroup.weblayer.webcontext.session.exception.SessionValueEncoderException;
import org.tinygroup.weblayer.webcontext.session.valueencode.SessionValueEncoder;

public abstract class AbstractSessionValueEncoder
extends BeanSupport
implements SessionValueEncoder {
    private static final String DEFAULT_CHARSET = "UTF-8";
    protected Encrypter encrypter;
    private String charset;

    public void setEncrypter(Encrypter encrypter) {
        this.encrypter = encrypter;
    }

    public String getCharset() {
        return this.charset == null ? DEFAULT_CHARSET : this.charset;
    }

    public void setCharset(String charset) {
        this.charset = StringUtil.trimToNull((String)charset);
    }

    protected abstract boolean doURLEncode();

    protected abstract boolean doCompress();

    @Override
    public String encode(Object value, SessionStore.StoreContext storeContext) throws SessionValueEncoderException {
        try {
            String encodedValue = this.encodeValue(value);
            if (this.encrypter != null) {
                encodedValue = new String(Base64.encodeBase64((byte[])this.encrypter.encrypt(this.compress(encodedValue.getBytes(DEFAULT_CHARSET)))), "8859_1");
            }
            if (this.doURLEncode() || this.encrypter != null) {
                encodedValue = StringEscapeUtil.escapeURL((String)encodedValue, (String)this.getCharset());
            }
            return encodedValue;
        }
        catch (Exception e) {
            throw new SessionEncoderException("Failed to encode single value", e);
        }
    }

    @Override
    public Object decode(String encodedValue, SessionStore.StoreContext storeContext) throws SessionValueEncoderException {
        try {
            if (this.doURLEncode() || this.encrypter != null) {
                encodedValue = StringEscapeUtil.unescapeURL((String)encodedValue, (String)this.getCharset());
            }
            if (this.encrypter != null) {
                encodedValue = new String(this.decompress(this.encrypter.decrypt(Base64.decodeBase64((byte[])encodedValue.getBytes("8859_1")))), DEFAULT_CHARSET);
            }
            return this.decodeValue(encodedValue);
        }
        catch (Exception e) {
            throw new SessionEncoderException("Failed to decode single value", e);
        }
    }

    private byte[] compress(byte[] data) throws SessionValueEncoderException {
        if (!this.doCompress()) {
            return data;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Deflater def = new Deflater(9, false);
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, def);
        try {
            dos.write(data);
        }
        catch (Exception e) {
            throw new SessionValueEncoderException(e);
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException iOException) {}
            def.end();
        }
        return baos.toByteArray();
    }

    private byte[] decompress(byte[] data) throws SessionValueEncoderException {
        if (!this.doCompress()) {
            return data;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        Inflater inf = new Inflater(false);
        InflaterInputStream iis = new InflaterInputStream(bais, inf);
        try {
            byte[] byArray = StreamUtil.readBytes((InputStream)iis, (boolean)true).toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new SessionValueEncoderException(e);
        }
        finally {
            inf.end();
        }
    }

    protected final TypeConverter getTypeConverter() {
        SimpleTypeConverter typeConverter = new SimpleTypeConverter();
        return typeConverter;
    }

    protected final String convertToString(Class<?> type, Object value, TypeConverter converter) {
        PropertyEditor editor;
        if (value instanceof String) {
            return (String)value;
        }
        if (converter instanceof PropertyEditorRegistry && type != null && type.isInstance(value) && (editor = ((PropertyEditorRegistry)converter).findCustomEditor(type, null)) != null) {
            editor.setValue(value);
            return editor.getAsText();
        }
        return (String)this.getTypeConverter().convertIfNecessary(value, String.class);
    }

    protected final Object convertToType(Class<?> type, String encodedValue, TypeConverter converter) {
        if (type != null && !type.equals(String.class)) {
            return converter.convertIfNecessary((Object)encodedValue, type);
        }
        return encodedValue;
    }

    protected abstract String encodeValue(Object var1) throws Exception;

    protected abstract Object decodeValue(String var1) throws Exception;
}

