/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session.valueencode.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.TypeConverter;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.weblayer.webcontext.session.valueencode.AbstractSessionValueEncoder;
import org.tinygroup.weblayer.webcontext.util.QueryStringParser;

public class MappedValuesEncoder
extends AbstractSessionValueEncoder {
    private Class<?> valueType;

    public void setValueType(Class<?> type) {
        this.valueType = type;
    }

    @Override
    protected boolean doURLEncode() {
        return false;
    }

    @Override
    protected boolean doCompress() {
        return true;
    }

    protected String getEqualSign() {
        return ":";
    }

    @Override
    protected String encodeValue(Object value) throws Exception {
        Assert.assertTrue((boolean)(value instanceof Map), (String)("wrong session attribute type: " + value.getClass()), (Object[])new Object[0]);
        Map map = (Map)value;
        LinkedHashMap encodedMap = CollectionUtil.createLinkedHashMap();
        TypeConverter converter = this.getTypeConverter();
        for (Map.Entry entry : map.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String encodedValue = this.convertToString(this.valueType, entry.getValue(), converter);
            encodedMap.put(key, encodedValue);
        }
        return new QueryStringParser(this.getCharset()).setEqualSign(this.getEqualSign()).append(encodedMap).toQueryString();
    }

    @Override
    protected Object decodeValue(String encodedValue) throws Exception {
        final LinkedHashMap map = CollectionUtil.createLinkedHashMap();
        final TypeConverter converter = this.getTypeConverter();
        new QueryStringParser(this.getCharset()){

            @Override
            protected void add(String key, String encodedValue) {
                map.put(key, MappedValuesEncoder.this.convertToType(MappedValuesEncoder.this.valueType, encodedValue, converter));
            }
        }.setEqualSign(this.getEqualSign()).parse(encodedValue);
        return map;
    }
}

