/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.BasicConstant;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.weblayer.webcontext.util.ServerCookie;

public class CookieSupport
extends Cookie {
    private static final Logger log = LoggerFactory.getLogger(CookieSupport.class);
    private static final FastMethod getHttpOnlyMethod = CookieSupport.getHttpOnlyMethod();
    private boolean httpOnly;

    public CookieSupport(String name, String value) {
        super((String)Assert.assertNotNull((Object)StringUtil.trimToNull((String)name), (String)"cookieName", (Object[])new Object[0]), value);
    }

    public CookieSupport(Cookie cookie) {
        this(cookie, null);
    }

    public CookieSupport(Cookie cookie, String name) {
        super((String)Assert.assertNotNull((Object)CookieSupport.getCookieName(cookie, name), (String)"cookieName", (Object[])new Object[0]), cookie.getValue());
        String path;
        String domain;
        this.setVersion(cookie.getVersion());
        this.setMaxAge(cookie.getMaxAge());
        this.setSecure(cookie.getSecure());
        String comment = cookie.getComment();
        if (!StringUtil.isEmpty((String)comment)) {
            this.setComment(comment);
        }
        if (!StringUtil.isEmpty((String)(domain = cookie.getDomain()))) {
            this.setDomain(domain);
        }
        if (!StringUtil.isEmpty((String)(path = cookie.getPath()))) {
            this.setPath(path);
        }
        if (cookie instanceof CookieSupport) {
            this.setHttpOnly(((CookieSupport)cookie).getHttpOnly());
        } else if (getHttpOnlyMethod != null) {
            try {
                this.setHttpOnly((Boolean)getHttpOnlyMethod.invoke((Object)cookie, BasicConstant.EMPTY_OBJECT_ARRAY));
            }
            catch (InvocationTargetException e) {
                log.warn("Invocation of Cookie.isHttpOnly() failed", e.getTargetException());
            }
        }
    }

    private static FastMethod getHttpOnlyMethod() {
        Method m = null;
        try {
            m = Cookie.class.getMethod("isHttpOnly", new Class[0]);
        }
        catch (Exception e) {
            try {
                m = Cookie.class.getMethod("getHttpOnly", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (m != null) {
            log.debug("Method Cookie.isHttpOnly() defined in current version of servlet api.  CookieSupport will make use of it.");
            return FastClass.create((ClassLoader)CookieSupport.class.getClassLoader(), Cookie.class).getMethod(m);
        }
        log.debug("No method Cookie.isHttpOnly() defined in current version of servlet api.");
        return null;
    }

    private static String getCookieName(Cookie cookie, String name) {
        if ((name = StringUtil.trimToNull((String)name)) == null) {
            name = StringUtil.trimToNull((String)cookie.getName());
        }
        return name;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean getHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public void setDomain(String domain) {
        if (!StringUtil.isEmpty((String)(domain = StringUtil.trimToEmpty((String)domain))) && !domain.startsWith(".")) {
            domain = "." + domain;
        }
        super.setDomain(domain);
    }

    public void addCookie(HttpServletResponse response) {
        response.addHeader(this.getCookieHeaderName(), this.getCookieHeaderValue());
    }

    public String getCookieHeaderName() {
        return ServerCookie.getCookieHeaderName(this.getVersion());
    }

    public String getCookieHeaderValue() throws IllegalArgumentException {
        return this.appendCookieHeaderValue(new StringBuilder()).toString();
    }

    private StringBuilder appendCookieHeaderValue(StringBuilder buf) throws IllegalArgumentException {
        int version = this.getVersion();
        String name = (String)ObjectUtil.defaultIfNull((Object)this.getName(), (Object)"");
        String value = this.getValue();
        String path = this.getPath();
        String domain = StringUtil.trimToNull((String)this.getDomain());
        String comment = StringUtil.trimToNull((String)this.getComment());
        int maxAge = StringUtil.isEmpty((String)this.getValue()) ? 0 : this.getMaxAge();
        boolean secure = this.getSecure();
        boolean httpOnly = this.getHttpOnly();
        ServerCookie.appendCookieValue(buf, version, name, value, path, domain, comment, maxAge, secure, httpOnly);
        return buf;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(this.getCookieHeaderName()).append(": ");
        int length = buf.length();
        try {
            this.appendCookieHeaderValue(buf);
        }
        catch (IllegalArgumentException e) {
            buf.setLength(length);
            buf.append(e.getMessage());
        }
        return buf.toString();
    }
}

