/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.util;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.tinygroup.commons.i18n.LocaleUtil;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.commons.tools.StringEscapeUtil;
import org.tinygroup.commons.tools.StringUtil;

public class QueryStringParser {
    private final String charset;
    private final StringBuilder queryStringBuffer;
    private String equalSign = "=";
    private String andSign = "&";

    public QueryStringParser() {
        this(null, null);
    }

    public QueryStringParser(String charset) {
        this(charset, null);
    }

    public QueryStringParser(String charset, String defaultCharset) {
        defaultCharset = (String)ObjectUtil.defaultIfNull((Object)StringUtil.trimToNull((String)defaultCharset), (Object)LocaleUtil.getContext().getCharset().name());
        this.charset = (String)ObjectUtil.defaultIfNull((Object)StringUtil.trimToNull((String)charset), (Object)defaultCharset);
        this.queryStringBuffer = new StringBuilder();
    }

    public String getCharacterEncoding() {
        return this.charset;
    }

    public String getEqualSign() {
        return this.equalSign;
    }

    public QueryStringParser setEqualSign(String equalSign) {
        this.equalSign = (String)ObjectUtil.defaultIfNull((Object)equalSign, (Object)"=");
        return this;
    }

    public String getAndSign() {
        return this.andSign;
    }

    public QueryStringParser setAndSign(String andSign) {
        this.andSign = (String)ObjectUtil.defaultIfNull((Object)andSign, (Object)"&");
        return null;
    }

    public QueryStringParser append(String key, String value) {
        try {
            key = StringEscapeUtil.escapeURL((String)((String)ObjectUtil.defaultIfNull((Object)key, (Object)"")), (String)this.charset);
            value = StringEscapeUtil.escapeURL((String)((String)ObjectUtil.defaultIfNull((Object)value, (Object)"")), (String)this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("invalid charset: " + this.charset, e);
        }
        if (this.queryStringBuffer.length() > 0) {
            this.queryStringBuffer.append(this.andSign);
        }
        this.queryStringBuffer.append(key).append(this.equalSign).append(value);
        return this;
    }

    public QueryStringParser append(Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            this.append(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String toQueryString() {
        String queryString = this.queryStringBuffer.toString();
        this.queryStringBuffer.setLength(0);
        return queryString.length() == 0 ? null : queryString;
    }

    public void parse(String queryString) {
        if ((queryString = StringUtil.trimToNull((String)queryString)) == null) {
            return;
        }
        int startIndex = 0;
        int ampIndex = queryString.indexOf(this.andSign);
        while (ampIndex >= 0) {
            this.addKeyValue(queryString.substring(startIndex, ampIndex));
            startIndex = ampIndex + 1;
            ampIndex = queryString.indexOf(this.andSign, startIndex);
        }
        this.addKeyValue(queryString.substring(startIndex));
    }

    protected void add(String key, String value) {
        Assert.unsupportedOperation((String)("You should extend class " + this.getClass().getSimpleName() + " and override method add(String, String)"), (Object[])new Object[0]);
    }

    private void addKeyValue(String keyValue) {
        String value;
        String key;
        int index = keyValue.indexOf(this.equalSign);
        if (index < 0) {
            key = keyValue;
            value = null;
        } else {
            key = keyValue.substring(0, index).trim();
            value = keyValue.substring(index + 1).trim();
        }
        if (!StringUtil.isEmpty((String)key)) {
            key = this.decode(key);
            value = this.decode(value);
            this.add(key, (String)ObjectUtil.defaultIfNull((Object)value, (Object)""));
        }
    }

    private String decode(String str) {
        try {
            return StringEscapeUtil.unescapeURL((String)str, (String)this.charset);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }
}

