package org.tinygroup.weblayer;

import javax.servlet.http.HttpServletRequest;

/**
 * request输入流可进行重复读的处理类
 * 
 * @author renhui
 *
 */
public class InputStreamRepeatRead {

	private boolean open = true;

	public InputStreamRepeatRead(boolean open) {
		super();
		this.open = open;
	}

	public HttpServletRequest requestWrapper(HttpServletRequest request) {
		if (open&&isPostMethod(request)) {
			return new MultipleReadServletRequest(request);
		}
		return request;
	}

	private boolean isPostMethod(HttpServletRequest request) {
		return request.getMethod().equalsIgnoreCase("post");
	}

}
