package org.tinygroup.weblayer;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.springutil.ExtendsSpringBeanContainer;
import org.tinygroup.weblayer.listener.ServletContextHolder;

/**
 * 此监听器需要放在ApplicationStartupListener监听器后面
 * @author renhui
 *
 */
public class TinySpringContainerBindingListener implements ServletContextListener {

	@Override
	public void contextInitialized(ServletContextEvent sce) {
		ExtendsSpringBeanContainer beanContainer = (ExtendsSpringBeanContainer) BeanContainerFactory
				.getBeanContainer(getClass().getClassLoader());
		ServletContextHolder.getServletContext().setAttribute(
				ApplicationStartupListener.TINY_SPRING_CONTAINER_KEY, beanContainer.getBeanContainerPrototype());
	}

	@Override
	public void contextDestroyed(ServletContextEvent sce) {
		ServletContextHolder.getServletContext().removeAttribute(ApplicationStartupListener.TINY_SPRING_CONTAINER_KEY);
	}

}
