/**
 * Copyright (c) 2012-2016, www.tinygroup.org (luo_guo@icloud.com).
 * <p>
 * Licensed under the GPL, Version 3.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.gnu.org/licenses/gpl.html
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.tinygroup.weblayer.util;

import org.tinygroup.remoteconfig.RemoteConfigReadClient;

import java.util.HashMap;
import java.util.Map;

public class TinyConfigParamUtil {
    public final static String REMOTE_CONFIG_CLASS = "remote-config-class";

    private static Map<String, String> map = new HashMap<String, String>();

    private static RemoteConfigReadClient readClient;

    public static RemoteConfigReadClient getReadClient() {
        return readClient;
    }

    public static void setReadClient(RemoteConfigReadClient readClient) {
        TinyConfigParamUtil.readClient = readClient;
    }

    public static void putConfig(String param, String value) {
        map.put(param, value);
    }

    public static void removeConfig(String param) {
        map.remove(param);
    }

    public static String getConfig(String name) {
        return map.get(name);
    }

    public static void clear() {
        map.clear();
        readClient = null;
    }
}
