package org.tinygroup.weblayer.webcontext.parser.impl;

import javax.servlet.http.HttpServletRequest;

import org.tinygroup.commons.tools.StringEscapeUtil;
import org.tinygroup.weblayer.webcontext.parser.upload.ParameterValueFilter;

public class EntityParameterValueFilter implements ParameterValueFilter {

	@Override
	public boolean isFiltering(HttpServletRequest request) {
		return true;
	}

	@Override
	public String filter(String key, String value, boolean isHtml) {
		if (value == null) {
			return null;
		}
		return StringEscapeUtil.escapeHtml(value);
	}

}
