/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser;

import junit.framework.TestCase;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.FastNameFilter;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.parser.filter.QuickNameFilter;
import org.tinygroup.xmlparser.node.XmlNode;

public class NameFilterTest
extends TestCase {
    XmlNode node = new XmlNode("root");

    public NameFilterTest() {
        for (int i = 0; i < 60; ++i) {
            XmlNode a = (XmlNode)this.node.addNode((Node)new XmlNode("a" + i));
            for (int j = 0; j < 60; ++j) {
                XmlNode b = (XmlNode)a.addNode((Node)new XmlNode("b" + j));
                for (int k = 0; k < 60; ++k) {
                    b.addNode((Node)new XmlNode("c" + k));
                }
            }
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.node = null;
    }

    public void testSpeed() {
        long t21 = System.currentTimeMillis();
        QuickNameFilter quick = new QuickNameFilter((Node)this.node);
        long t22 = System.currentTimeMillis();
        System.out.println("quick\u7528\u65f6" + (t22 - t21));
        long t1 = System.currentTimeMillis();
        for (int x = 0; x < 10000; ++x) {
            XmlNode node = (XmlNode)quick.findNode("b6");
        }
        long t2 = System.currentTimeMillis();
        System.out.println("QuickNameFilter\u7528\u65f6" + (t2 - t1));
    }

    public void testSpeed1() {
        long t21 = System.currentTimeMillis();
        FastNameFilter fast = new FastNameFilter((Node)this.node);
        long t22 = System.currentTimeMillis();
        System.out.println("fast\u7528\u65f6" + (t22 - t21));
        long t1 = System.currentTimeMillis();
        for (int x = 0; x < 10000; ++x) {
            XmlNode node = (XmlNode)fast.findNode("b6");
        }
        long t2 = System.currentTimeMillis();
        System.out.println("FastNameFilter\u7528\u65f6" + (t2 - t1));
    }

    public void testSpeed2() {
        long t11 = System.currentTimeMillis();
        NameFilter filter = new NameFilter((Node)this.node);
        long t12 = System.currentTimeMillis();
        System.out.println("Name\u7528\u65f6" + (t12 - t11));
        long t1 = System.currentTimeMillis();
        String nodeName = null;
        for (int x = 0; x < 10; ++x) {
            nodeName = filter.findNode("b6").toString();
        }
        long t2 = System.currentTimeMillis();
        System.out.println("NameFilter\u7528\u65f6" + (t2 - t1));
    }
}

