/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser;

import java.io.File;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import junit.framework.TestCase;
import org.tinygroup.commons.file.IOUtils;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;
import org.tinygroup.xmlparser.XmlDocument;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class FilterTest
extends TestCase {
    XmlDocument doc = null;

    protected void setUp() throws Exception {
        File file1 = new File("src/test/resources/dtd.xml");
        System.out.println(file1.getAbsolutePath());
        XmlStringParser parser = new XmlStringParser();
        FileObject file = VFS.resolveFile((String)("file:" + file1.getAbsolutePath()));
        this.doc = parser.parse(IOUtils.readFromInputStream((InputStream)file.getInputStream(), (String)"utf-8"));
        super.setUp();
    }

    public void testParser() {
        System.out.println(this.doc);
        FilterTest.assertNotNull((Object)this.doc);
    }

    public void testFindNode() {
        NameFilter filter = new NameFilter(this.doc.getRoot());
        List nodes = filter.findNodeList("note");
        FilterTest.assertEquals((int)1, (int)nodes.size());
    }

    public void testIncludeAttributeFindNode() {
        NameFilter filter = new NameFilter(this.doc.getRoot());
        List nodes = filter.findNodeList("to");
        FilterTest.assertEquals((int)2, (int)nodes.size());
        Hashtable<String, String> includeAttribute = new Hashtable<String, String>();
        includeAttribute.put("a", "1");
        filter.setIncludeAttribute(includeAttribute);
        List nodes1 = filter.findNodeList("to");
        FilterTest.assertEquals((int)1, (int)nodes1.size());
    }

    public void testExcludeAttributeFindNode() {
        NameFilter filter = new NameFilter(this.doc.getRoot());
        List nodes = filter.findNodeList("to");
        FilterTest.assertEquals((int)2, (int)nodes.size());
        Hashtable<String, String> excludeAttribute = new Hashtable<String, String>();
        excludeAttribute.put("a", "1");
        filter.setExcludeAttribute(excludeAttribute);
        List nodes1 = filter.findNodeList("to");
        FilterTest.assertEquals((int)1, (int)nodes1.size());
    }

    public void testIncludeAttributeV() {
        NameFilter filter = new NameFilter(this.doc.getRoot());
        List nodes = filter.findNodeList("from");
        FilterTest.assertEquals((int)7, (int)nodes.size());
        String[] incV1 = new String[]{"a", "b"};
        filter.setIncludeAttributes(incV1);
        List nodes1 = filter.findNodeList("from");
        FilterTest.assertEquals((int)1, (int)nodes1.size());
        String[] incV2 = new String[]{"a"};
        filter.setIncludeAttributes(incV2);
        List nodes2 = filter.findNodeList("from");
        FilterTest.assertEquals((int)2, (int)nodes2.size());
    }

    public void testExcludeAttributeV() {
        NameFilter filter = new NameFilter(this.doc.getRoot());
        List nodes = filter.findNodeList("from");
        FilterTest.assertEquals((int)7, (int)nodes.size());
        String[] excV1 = new String[]{"a", "b"};
        filter.setExcludeAttribute(excV1);
        List nodes1 = filter.findNodeList("from");
        FilterTest.assertEquals((int)4, (int)nodes1.size());
        String[] excV2 = new String[]{"a"};
        filter.setExcludeAttribute(excV2);
        List nodes2 = filter.findNodeList("from");
        FilterTest.assertEquals((int)5, (int)nodes2.size());
    }

    public void testIncludeText() {
        NameFilter filter = new NameFilter(this.doc.getRoot());
        List nodes = filter.findNodeList("from");
        FilterTest.assertEquals((int)7, (int)nodes.size());
        filter.setIncludeText(new String[]{"John"});
        List nodes1 = filter.findNodeList("from");
        FilterTest.assertEquals((int)2, (int)nodes1.size());
    }

    public void testExcludeText() {
        NameFilter filter = new NameFilter(this.doc.getRoot());
        List nodes = filter.findNodeList("from");
        FilterTest.assertEquals((int)7, (int)nodes.size());
        filter.setExcludeText(new String[]{"John"});
        List nodes1 = filter.findNodeList("from");
        FilterTest.assertEquals((int)5, (int)nodes1.size());
    }

    public void testIncludeNode() {
        NameFilter filter = new NameFilter(this.doc.getRoot());
        List nodes = filter.findNodeList("body");
        FilterTest.assertEquals((int)4, (int)nodes.size());
        filter.setIncludeNode(new String[]{"a", "b"});
        List nodes1 = filter.findNodeList("body");
        FilterTest.assertEquals((int)1, (int)nodes1.size());
        filter.setIncludeNode(new String[]{"a"});
        FilterTest.assertEquals((int)2, (int)filter.findNodeList("body").size());
    }

    public void testExcludeNode() {
        NameFilter filter = new NameFilter(this.doc.getRoot());
        List nodes = filter.findNodeList("body");
        FilterTest.assertEquals((int)4, (int)nodes.size());
        filter.setExcludeNode(new String[]{"a", "b"});
        List nodes1 = filter.findNodeList("body");
        FilterTest.assertEquals((int)2, (int)nodes1.size());
        filter.setExcludeNode(new String[]{"a"});
        FilterTest.assertEquals((int)2, (int)filter.findNodeList("body").size());
    }

    public void testXorNode() {
        NameFilter filter = new NameFilter(this.doc.getRoot());
        List nodes = filter.findNodeList("body");
        FilterTest.assertEquals((int)4, (int)nodes.size());
        filter.setXorSubNode(new String[]{"a", "c"});
        FilterTest.assertEquals((int)2, (int)filter.findNodeList("body").size());
    }

    public void testXorPro() {
        NameFilter filter = new NameFilter(this.doc.getRoot());
        List nodes = filter.findNodeList("from");
        FilterTest.assertEquals((int)7, (int)nodes.size());
        filter.setXorProperties(new String[]{"a", "b"});
        FilterTest.assertEquals((int)3, (int)filter.findNodeList("from").size());
    }
}

