/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser;

import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.tinygroup.parser.Node;
import org.tinygroup.xmlparser.XmlNodeType;
import org.tinygroup.xmlparser.node.XmlNode;

public class INodeTest
extends TestCase {
    XmlNode node = null;

    protected void setUp() throws Exception {
        this.node = new XmlNode("aa");
        super.setUp();
    }

    public void testEnDeCode() {
        this.node = new XmlNode(XmlNodeType.TEXT);
        this.node.setContent("&amp;&lt;&gt;&quot;&nbsp;&copy;&reg;");
        System.out.println(this.node.getContent());
        try {
            this.node.write((OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testEnDeCode1() {
        System.out.println();
        this.node = new XmlNode("aa");
        this.node.setAttribute("a", "&amp;&lt;&gt;&quot;&nbsp;&copy;&reg;");
        System.out.println(this.node.getAttribute("a"));
        try {
            this.node.write((OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetHeader() {
        this.node.setAttribute("a", "b");
        StringBuffer sb = new StringBuffer();
        this.node.getHeader(sb);
        INodeTest.assertEquals((String)"<aa a=\"b\">", (String)sb.toString());
    }

    public void testGetFooter() {
        StringBuffer sb = new StringBuffer();
        this.node.getFooter(sb);
        INodeTest.assertEquals((String)"</aa>", (String)sb.toString());
    }

    public void testGetRoot() {
        XmlNode n = new XmlNode("a");
        XmlNode n1 = new XmlNode("b");
        n.addNode((Node)n1);
        XmlNode n2 = new XmlNode("b");
        n1.addNode((Node)n2);
        INodeTest.assertEquals((Object)n, (Object)n2.getRoot());
    }

    public void testGetParent() {
        XmlNode n = new XmlNode("a");
        XmlNode n1 = new XmlNode("b");
        n.addNode((Node)n1);
        XmlNode n2 = new XmlNode("b");
        n1.addNode((Node)n2);
        INodeTest.assertEquals((Object)n, (Object)n1.getParent());
        INodeTest.assertEquals((Object)n1, (Object)n2.getParent());
    }

    public void testGetBody() {
        XmlNode n = new XmlNode(XmlNodeType.COMMENT);
        n.setContent("abc");
        INodeTest.assertEquals((String)"abc", (String)n.getContent());
        n = new XmlNode(XmlNodeType.TEXT);
        n.setContent("abc");
        INodeTest.assertEquals((String)"abc", (String)n.getContent());
        n = new XmlNode(XmlNodeType.CDATA);
        n.setContent("abc");
        INodeTest.assertEquals((String)"abc", (String)n.getContent());
    }

    public void testWrite() {
        this.node.setContent("abc");
        this.node.addNode((Node)new XmlNode("b"));
        try {
            this.node.write((OutputStream)System.out);
        }
        catch (IOException e) {
            INodeTest.fail((String)("\u4e0d\u5e94\u8be5\u6709\u5f02\u5e38" + e.getMessage()));
        }
    }

    public void testGetXmlNodeType() {
        INodeTest.assertEquals((Object)XmlNodeType.ELEMENT, (Object)this.node.getNodeType());
    }

    public void testGetAttribute() {
        this.node.setAttribute("a", "b");
        INodeTest.assertEquals((String)"b", (String)this.node.getAttribute("a"));
    }

    public void testAddNode() {
        XmlNode n = new XmlNode("c");
        this.node.addNode((Node)n);
        INodeTest.assertEquals((String)"<aa><c></c></aa>", (String)this.node.toString());
    }

    public void testRemoveNode() {
        XmlNode n = new XmlNode("c");
        this.node.addNode((Node)n);
        INodeTest.assertEquals((String)"<aa><c></c></aa>", (String)this.node.toString());
        this.node.removeNode((Node)n);
        INodeTest.assertEquals((String)"<aa></aa>", (String)this.node.toString());
        INodeTest.assertNull((Object)n.getParent());
    }

    public void testGetContent() {
        XmlNode node = new XmlNode(XmlNodeType.COMMENT);
        node.setContent("aaa");
        INodeTest.assertEquals((String)"aaa", (String)node.getContent().toString());
    }

    public void testToStringBuffer() {
        this.node.setAttribute("a", "b");
        INodeTest.assertEquals((String)"<aa a=\"b\"></aa>", (String)this.node.toStringBuffer().toString());
    }

    public void testGetAttributes() {
        INodeTest.assertNull((Object)this.node.getAttribute("a"));
        this.node.setAttribute("a", "b");
        INodeTest.assertEquals((String)"b", (String)this.node.getAttribute("a"));
        this.node.setAttribute("a", null);
        INodeTest.assertNull((Object)this.node.getAttribute("a"));
    }

    public void testGetSubNodes() {
        for (int i = 0; i < 100; ++i) {
            this.node.addNode((Node)new XmlNode("node" + i));
        }
        INodeTest.assertEquals((int)100, (int)this.node.getSubNodes().size());
    }

    public void testToStringEveryType() {
        XmlNode n = new XmlNode(XmlNodeType.CDATA);
        n.setContent("aa");
        INodeTest.assertEquals((String)"<![CDATA[aa]]>", (String)n.toString());
        n = new XmlNode(XmlNodeType.COMMENT);
        n.setContent("aa");
        INodeTest.assertEquals((String)"<!--aa-->", (String)n.toString());
        n = new XmlNode(XmlNodeType.XML_DECLARATION);
        n.setAttribute("version", "1.0");
        n.setAttribute("encoding", "UTF-8");
        n.setAttribute("standalone", "no");
        INodeTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>", (String)n.toString());
        n = new XmlNode(XmlNodeType.DOCTYPE);
        n.setContent("aa");
        INodeTest.assertEquals((String)"<!DOCTYPE aa>", (String)n.toString());
        n = new XmlNode(XmlNodeType.PROCESSING_INSTRUCTION);
        n.setContent("aa bb  cc");
        INodeTest.assertEquals((String)"<?aa bb  cc?>", (String)n.toString());
        n = new XmlNode(XmlNodeType.TEXT);
        n.setContent("aa");
        INodeTest.assertEquals((String)"aa", (String)n.toString());
    }
}

